<?php
use App\Models\Inventaris\Perawatan;
use App\Models\Roles;

use Carbon\Carbon;
?>
<?php
if (auth()->user()->level == 'admin') {
  # code...
  $id = Roles::where('user_id', auth()->user()->id)->first();
  $mytime = Carbon::now();
  $jumlah_perawatan = Perawatan::where('proyek_id', $id->proyek_id)
      ->where('servis_berikutnya', '<=', $mytime)
      ->count('servis_berikutnya');
} else {
  # code...
  # code...
  // $id = Roles::where('user_id', auth()->user()->id)->first();
  $mytime = Carbon::now();
  $jumlah_perawatan = Perawatan::where('servis_berikutnya', '<=', $mytime)
      ->count('servis_berikutnya');
}


?>
<!-- [ Sidebar Menu ] end --> <!-- [ Header Topbar ] start -->
<header class="pc-header">
    <div class="header-wrapper"> <!-- [Mobile Media Block] start -->
        <div class="me-auto pc-mob-drp">
            <ul class="list-unstyled">
                <li class="pc-h-item header-mobile-collapse">
                    <a href="#" class="pc-head-link ms-0" id="sidebar-hide">
                        <i class="ti ti-menu-2"></i>
                    </a>
                </li>
                <li class="pc-h-item pc-sidebar-popup">
                    <a href="#" class="pc-head-link head-link-secondary ms-0" id="mobile-collapse">
                        <i class="ti ti-menu-2"></i>
                    </a>
                </li>
                <li class="dropdown pc-h-item d-inline-flex d-md-none">
                    <p style="font-size: 12px" class="mt-3"> PT BUMI MINERAL SULAWESI</p>
                    <div class="dropdown-menu pc-h-dropdown drp-search">
                        <form class="px-3">
                            <div class="form-group mb-0 d-flex align-items-center">
                                <i data-feather="search"></i>
                                <input type="search" class="form-control border-0 shadow-none"
                                    placeholder="Search here. . .">
                            </div>
                        </form>
                    </div>
                </li>

                <li class="pc-h-item d-none d-md-inline-flex">
                    <div class="header-search">
                        
                        <img src="<?php echo e(asset('assets/images/bmsblack.png')); ?>" width="110px" alt="">
                        
                    </div>
                    
                </li>
            </ul>
        </div>
        <!-- [Mobile Media Block end] -->
        <div class="ms-auto">
            <ul class="list-unstyled">

                <li class="dropdown pc-h-item text-primary">
                    <?php echo e(auth()->user()->name); ?>

                </li>

                <li class="dropdown pc-h-item">
                    <a class="pc-head-link  dropdown-toggle arrow-none me-0" data-bs-toggle="dropdown" href="#"
                        role="button" aria-haspopup="false" aria-expanded="false">
                        <i class="ti ti-bell"></i>
                        <?php if($jumlah_perawatan <= 0): ?>
                        <?php else: ?>
                            <span
                                class="position-absolute top-0 start-100 translate-middle p-2 bg-danger border border-light rounded-circle">
                                <span class="visually-hidden"></span>
                        <?php endif; ?>
                        </span>
                    </a>
                    <div class="dropdown-menu dropdown-notification dropdown-menu-end pc-h-dropdown">
                        <div class="dropdown-header">
                            
                            <h5>Notifikasi<span class="badge bg-warning rounded-pill ms-1"></span></h5>
                        </div>
                        <div class="dropdown-header px-0 text-wrap header-notification-scroll position-relative"
                            style="max-height: calc(100vh - 215px)">
                        <?php if($jumlah_perawatan <= 0): ?>
                            <div class="text-success text-center"><i class="bi bi-bell"></i> Tidak Ada Pemberitahuan !!!</div>

                        <?php else: ?>
                        <div class="list-group list-group-flush w-100">
                          <?php if(auth()->user()->level == 'admin'): ?>
                          <a href="/admin_menu" class="text-decoration-none">
                              
                          <?php else: ?>
                          <a href="#" class="text-decoration-none" >
                              
                          <?php endif; ?>
                              <div class="list-group-item list-group-item-action">
                                  <div class="d-flex">
                                      <div class="flex-shrink-0">
                                          <div class="user-avtar bg-light-warning"><i
                                                  class="ti ti-bell-ringing"></i></div>
                                      </div>
                                      <div class="flex-grow-1 ms-1">
                                          <span class="float-end text-muted"><i class="bi bi-bell"></i></span>
                                          <h6 class="">Inventaris/Perawatan</h6>
                                          <p class="badge rounded-pill bg-light-danger fs-6"><i
                                                  class=" fs-6 bi bi-tools"></i> <?php echo e($jumlah_perawatan); ?> </p>

                                      </div>
                                  </div>
                                  </div>
                          </a>

                      </div>
                        
                        <?php endif; ?>
                           
                        </div>
                        
                    </div>
                    <div class="dropdown-divider"></div>
                    
        </div>
        </li>
        <li class="dropdown pc-h-item header-user-profile">
            <a class="pc-head-link head-link-primary dropdown-toggle arrow-none me-0" data-bs-toggle="dropdown"
                href="#" role="button" aria-haspopup="false" aria-expanded="false">
                <img src="<?php echo e(asset('assets/images/user/boy.png')); ?>" alt="user-image" class="user-avtar">
                <span>
                    <i class="ti ti-settings"></i>
                </span>
            </a>
            <div class="dropdown-menu dropdown-user-profile dropdown-menu-end pc-h-dropdown">
                <div class="dropdown-header">
                    <h6>Selamat Datang, <span class="small text-muted"> <?php echo e(auth()->user()->name); ?></span></h6>
                    <hr>
                    <div class="profile-notification-scroll position-relative" style="max-height: calc(100vh - 280px)">
                        <a href="../application/account-profile-v1.html" class="dropdown-item">
                            <i class="ti ti-settings"></i>
                            <span>Pengaturan</span>
                        </a>
                        <a href="../application/social-profile.html" class="dropdown-item">
                            <i class="ti ti-user"></i>
                            <span>Profile</span>
                        </a>
                        <a href="#" data-bs-toggle="modal" data-bs-target="#logoutModal" class="dropdown-item">
                            <i class="ti ti-logout"></i>
                            <span>Logout</span>
                        </a>

                    </div>
                </div>
            </div>
        </li>
        </ul>
    </div>
    </div>
</header>
<!-- [ Header ] end -->
<?php /**PATH C:\Users\CC\Documents\Kantor\Apps\bms-asset\resources\views/layouts/header.blade.php ENDPATH**/ ?>