<!DOCTYPE html>
<html lang="en">

<?php

use Carbon\Carbon;
?>

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="<?php echo e($web->web_deskripsi); ?>">
    <meta name="author" content="<?php echo e($web->web_nama); ?>">
    <meta name="keywords" content="">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />

    <!-- FAVICON -->
    <?php if($web->web_logo == '' || $web->web_logo == 'default.png'): ?>
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(url('/assets/default/web/default.png')); ?>" />
    <?php else: ?>
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('storage/web/' . $web->web_logo)); ?>" />
    <?php endif; ?>

    <title>BMS-ASET-BRG-KELUAR_<?php echo e(Carbon::parse($tglawal)->translatedFormat('d-m-Y')); ?>/<?php echo e(Carbon::parse($tglakhir)->translatedFormat('d-m-Y')); ?></title>

    <style>
        * {
            font-family: Arial, Helvetica, sans-serif;
        }
        #img {
            width: 200px;
            height: 200px;
        }

        #table1 {
            border-collapse: collapse;
            width: 100%;
            margin-top: 32px;
        }

        #table1 td,
        #table1 th {
            border: 1px solid #2c3e50;
            padding: 8px;
        }

        #table1 th {
            padding-top: 12px;
            padding-bottom: 12px;
            color: black;
            font-size: 12px;
        }

        #table1 td {
            font-size: 11px;
        }

        .font-medium {
            font-weight: 500;
        }

        .font-bold {
            font-weight: 600;
        }

        .d-2 {
            display: flex;
            align-items: flex-start;
            margin-top: 32px;
        }
    </style>

</head>

<body onload="window.print()">

    <center>
        <?php if($web->web_logo == '' || $web->web_logo == 'default.png'): ?>
        <img src="<?php echo e(url('/assets/images/bmsblack.png')); ?>" width="150px" alt="">
        <?php else: ?>
        <img src="<?php echo e(asset('storage/web/' . $web->web_logo)); ?>" width="80px" alt="">
        <?php endif; ?>
    </center>

    <center>
        <h3 class="font-medium">PRODUKSI</h3>
        <h3 class="font-medium">Laporan Barang Keluar</h3>
        <?php if($tglawal == ''): ?>
        <h4 class="font-medium">Semua Tanggal</h4>
        <?php else: ?>
        
        <?php endif; ?>
        Tanggal <?php echo e(Carbon::parse($tglawal)->translatedFormat('d-m-Y')); ?> s/d <?php echo e(Carbon::parse($tglakhir)->translatedFormat('d-m-Y')); ?>

    </center>


    <table border="1" id="table1">
        <thead>
            <tr>
                <th align="center" width="1%">NO</th>
                <th>KODE BARANG</th>
                <th>NAMA BARANG</th>
                <th>MEREK</th>
                <th>JUMLAH</th>
                <th>SATUAN</th>
                <th>PENGGUNA</th>
                <th>DIVISI</th>
                <th>LOKASI</th>
                <th>TANGGAL</th>
            </tr>
        </thead>
        <tbody>
            <?php $no=1; ?>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td align="center"><?php echo e($no++); ?></td>
                <td><?php echo e($d->gs_barang->kode_barang); ?></td>
                <td><?php echo e($d->gs_barang->nama_barang); ?></td>
                <td><?php echo e($d->gs_barang->merek); ?></td>
                <td align="center"><?php echo e($d->jumlah); ?></td>
                <td align="center"><?php echo e($d->satuan); ?></td>
                <td><?php echo e($d->nama); ?></td>
                <td><?php echo e($d->n_divisi); ?></td>
                <td><?php echo e($d->lokasi); ?></td>
                <td align="center"><?php echo e(Carbon::parse($d->tanggal)->translatedFormat('d-m-Y')); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

</body>

</html><?php /**PATH C:\Users\CC\Documents\Kantor\Apps\bms-asset\resources\views/superadmin/gs/produksi/consumable/gs_out_barang/print.blade.php ENDPATH**/ ?>