<?php

use App\Http\Controllers\Admin_Area\Admin_Area_Controller;
use App\Http\Controllers\Admin_Area\Admin_Kategori_Controller;
use App\Http\Controllers\Admin_Area\Admin_Menu_Controller;
use App\Http\Controllers\Admin_Area\Admin_Profil_Controller;
use App\Http\Controllers\Admin_Area\Consumable\Consumable_Barang_Controller;
use App\Http\Controllers\Admin_Area\Consumable\Consumable_Controller;
use App\Http\Controllers\Admin_Area\Consumable\Consumable_In_Controller;
use App\Http\Controllers\Admin_Area\Consumable\Consumable_Out_Controller;
use App\Http\Controllers\Admin_Area\Inventaris\Inventaris_Barang_Controller;
use App\Http\Controllers\Admin_Area\Inventaris\Inventaris_Controller;
use App\Http\Controllers\Admin_Area\Inventaris\Inventaris_In_Controller;
use App\Http\Controllers\Admin_Area\Inventaris\Inventaris_Out_Controller;
use App\Http\Controllers\Admin_Area\Inventaris\Inventaris_Perawatan_Controller;
use App\Http\Controllers\Admin_Area\Inventaris\Inventaris_Perawatan_Riwayat_Controller;
use App\Http\Controllers\Admin_Area\Kendaraan\Data_Kendaraan_Controller;
use App\Http\Controllers\Admin_Area\Kendaraan\Kendaraan_Controller;
use App\Http\Controllers\Admin_Area\Kendaraan\Kendaraan_In_Controller;
use App\Http\Controllers\Auth\Login_Controller;
use App\Http\Controllers\Get_Controller;
use App\Http\Controllers\Kategori_Controller;
use App\Http\Controllers\Superadmin\Gs\Konstruksi\Consumable\Superadmin_Gs_Konstruksi_Barang_Controller;
use App\Http\Controllers\Superadmin\Gs\Konstruksi\Consumable\Superadmin_Gs_Konstruksi_In_Barang_Controller;
use App\Http\Controllers\Superadmin\Gs\Konstruksi\Consumable\Superadmin_Gs_Konstruksi_Out_Barang_Controller;
use App\Http\Controllers\Superadmin\Gs\Konstruksi\Consumable\Superadmin_Gs_Konstruksi_Stok_Barang_Controller;
use App\Http\Controllers\Superadmin\Gs\Produksi\Consumable\Superadmin_Gs_Produksi_Barang_Controller;
use App\Http\Controllers\Superadmin\Gs\Produksi\Consumable\Superadmin_Gs_Produksi_In_Barang_Controller;
use App\Http\Controllers\Superadmin\Gs\Produksi\Consumable\Superadmin_Gs_Produksi_Out_Barang_Controller;
use App\Http\Controllers\Superadmin\Gs\Produksi\Consumable\Superadmin_Gs_Produksi_Stok_Barang_Controller;
use App\Http\Controllers\Superadmin\Perusahaan\Consumable\Superadmin_Consumable_Barang_Controller;
use App\Http\Controllers\Superadmin\Perusahaan\Consumable\Superadmin_Consumable_Controller;
use App\Http\Controllers\Superadmin\Perusahaan\Consumable\Superadmin_Consumable_In_Controller;
use App\Http\Controllers\Superadmin\Perusahaan\Consumable\Superadmin_Consumable_Out_Controller;
use App\Http\Controllers\Superadmin\Perusahaan\Inventaris\Superadmin_Inventaris_Barang_Controller;
use App\Http\Controllers\Superadmin\Perusahaan\Inventaris\Superadmin_Inventaris_Controller;
use App\Http\Controllers\Superadmin\Perusahaan\Inventaris\Superadmin_Inventaris_In_Controller;
use App\Http\Controllers\Superadmin\Perusahaan\Inventaris\Superadmin_Inventaris_Out_Controller;
use App\Http\Controllers\Superadmin\Perusahaan\Inventaris\Superadmin_Inventaris_Perawatan_Controller;
use App\Http\Controllers\Superadmin\Perusahaan\Inventaris\Superadmin_Inventaris_Perawatan_Riwayat_Controller;
use App\Http\Controllers\Superadmin\Perusahaan\Kendaraan\Superadmin_Data_Kendaraan_Controller;
use App\Http\Controllers\Superadmin\Perusahaan\Kendaraan\Superadmin_Kendaraan_Controller;
use App\Http\Controllers\Superadmin\Perusahaan\Kendaraan\Superadmin_Kendaraan_In_Controller;
use App\Http\Controllers\Superadmin\Perusahaan\Kendaraan\Superadmin_Kendaraan_Out_Controller;
use App\Http\Controllers\Superadmin\Perusahaan\Kendaraan\Superadmin_Kendaraan_Pajak_Controller;
use App\Http\Controllers\Superadmin\Perusahaan\Kendaraan\Superadmin_Kendaraan_Pajak_Riwayat_Controller;
use App\Http\Controllers\Superadmin\Perusahaan\Kendaraan\Superadmin_Kendaraan_Servis_Controller;
use App\Http\Controllers\Superadmin\Perusahaan\Kendaraan\Superadmin_Kendaraan_Servis_Riwayat_Controller;
use App\Http\Controllers\Superadmin\Perusahaan\Superadmin_Perusahaan_Barang_Controller;
use App\Http\Controllers\Superadmin\Perusahaan\Superadmin_Perusahaan_Controller;
use App\Http\Controllers\Superadmin\Superadmin_Divisi_Controller;
use App\Http\Controllers\Superadmin\Superadmin_Master\Superadmin_Master_Akun_Controller;
use App\Http\Controllers\Superadmin\Superadmin_Master\Superadmin_Master_Controller;
use App\Http\Controllers\Superadmin\Superadmin_Master\Superadmin_Master_Perusahaan_Controller;
use App\Http\Controllers\Superadmin\Superadmin_Master\Superadmin_Master_Roles_Controller;
use App\Http\Controllers\Superadmin\Superadmin_Proyek_Controller;
use App\Http\Controllers\Superadmin\Superadmin_Sub_Divisi_Controller;
use App\Http\Controllers\View_Gambar_Controller;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', [Login_Controller::class, 'index'])->name('login');
Route::post('/', [Login_Controller::class, 'authlogin']);
Route::get('/logout', [Login_Controller::class, 'logout'])->name('logout');

Route::group(['middleware' => 'auth'], function () {
    Route::middleware(['superadmin_master'])->group(function () {
        Route::resource('/superadmin_master', Superadmin_Master_Controller::class);

        // Perusahaa
        Route::resource('/superadmin_master_perusahaan', Superadmin_Master_Perusahaan_Controller::class);
        // Divis
        Route::resource('/superadmin_master_divisi', Superadmin_Divisi_Controller::class);
        //   Proyek
        Route::resource('/superadmin_master_proyek', Superadmin_Proyek_Controller::class);
        // Sub Divisi
        Route::resource('/superadmin_master_sub_divisi', Superadmin_Sub_Divisi_Controller::class);
        // Barang
        Route::resource('/sa_master_gs_konstruksi_barang', Superadmin_Gs_Konstruksi_Barang_Controller::class);
        // Akun
        Route::resource('/superadmin_master_akun', Superadmin_Master_Akun_Controller::class);
        // Roles
        Route::resource('/superadmin_master_roles', Superadmin_Master_Roles_Controller::class);

        // superadmin Perusahaan
        Route::resource('/superadmin_perusahaan', Superadmin_Perusahaan_Controller::class);
        Route::get('/superadmin_divisi/{id}/divisi', [Superadmin_Perusahaan_Controller::class, 'divisi']);
        Route::get('/superadmin_proyek/{data}/divisi/{id}', [Superadmin_Perusahaan_Controller::class, 'proyek']);
        Route::get('/superadmin_sub_divisi/{data}/{divisi}/proyek/{id}', [Superadmin_Perusahaan_Controller::class, 'sub_divisi']);

        // superadmin barang
        Route::get('/superadmin_barang/{data}/sub_divisi/{id}', [Superadmin_Perusahaan_Barang_Controller::class, 'index']);
        Route::get('/superadmin_barang/show_data/{data}/{id}', [Superadmin_Perusahaan_Barang_Controller::class, 'show_data'])->name('data.stok.barang');
        Route::get('/bms_aset/print_all/{proyek}/{sub_divisi}/{tglawal}&{tglakhir}', [Superadmin_Perusahaan_Barang_Controller::class, 'print']);

        // Superadmin Consumable
        Route::get('/superadmin_consumable/consumable/{id}', [Superadmin_Consumable_Controller::class, 'index']);
        Route::get('/superadmin_consumable/consumable/get_data/{id}', [Superadmin_Consumable_Controller::class, 'get_data']);
        Route::get('/superadmin_consumable/print_all/{id}/{tglawal}&{tglakhir}', [Superadmin_Consumable_Controller::class, 'print']);
        Route::get('/superadmin_consumable/show/{id}/{it}', [Superadmin_Consumable_Controller::class, 'show']);
        Route::get('/superadmin_consumable/gambar/{id}', [Superadmin_Consumable_Controller::class, 'gambar']);

        // Consumbale Barang
        Route::get('/superadmin_consumable/consumable/barang/{id}', [Superadmin_Consumable_Barang_Controller::class, 'index']);
        Route::get('/superadmin_consumable/consumable/create/{id}', [Superadmin_Consumable_Barang_Controller::class, 'create']);
        Route::post('/superadmin_consumable_barang/post/{id}', [Superadmin_Consumable_Barang_Controller::class, 'store']);
        Route::get('/superadmin_consumable_barang/show/{id}/{it}', [Superadmin_Consumable_Barang_Controller::class, 'show']);
        Route::put('/superadmin_consumable_barang/update/{id}/{it}', [Superadmin_Consumable_Barang_Controller::class, 'update']);
        Route::delete('/superadmin_consumable_barang/delete/{id}/{it}', [Superadmin_Consumable_Barang_Controller::class, 'destroy']);
        // Consumbale Masuk
        Route::get('/superadmin_consumable/consumable/masuk/{id}', [Superadmin_Consumable_In_Controller::class, 'index']);
        Route::get('/superadmin_consumable/consumable/masuk/get_data/{id}', [Superadmin_Consumable_In_Controller::class, 'get_data']);
        Route::get('/superadmin_consumable/cari_barang/{id}', [Superadmin_Consumable_In_Controller::class, 'cari_barang']);
        Route::get('/superadmin_consumable/add_barang_masuk/{id}', [Superadmin_Consumable_In_Controller::class, 'create']);
        Route::post('/superadmin_consumable/barang_masuk/post/{id}', [Superadmin_Consumable_In_Controller::class, 'store']);
        Route::get('/superadmin_consumable/show_barang_masuk/{id}/{it}', [Superadmin_Consumable_In_Controller::class, 'show']);
        Route::put('/superadmin_consumable/update_barang_masuk/{id}/{it}', [Superadmin_Consumable_In_Controller::class, 'update']);
        Route::delete('/superadmin_consumable/consumable/masuk/{id}', [Superadmin_Consumable_In_Controller::class, 'destroy']);
        Route::get('/superadmin_consumable/print_barang_masuk/{id}/{tglawal}&{tglakhir}', [Superadmin_Consumable_In_Controller::class, 'print']);
        Route::get('/consumable/view_gambar/{id}', [Superadmin_Consumable_In_Controller::class, 'gambar']);
        // Consumbale Keluar
        Route::get('/superadmin_consumable/consumable/keluar/{id}', [Superadmin_Consumable_Out_Controller::class, 'index']);
        Route::get('/superadmin_consumable/consumable/keluar/get_data/{id}', [Superadmin_Consumable_Out_Controller::class, 'get_data']);
        Route::get('/superadmin_consumable/keluar/cari_barang/{id}', [Superadmin_Consumable_Out_Controller::class, 'cari_barang']);
        Route::get('/superadmin_consumable/add_barang_keluar/{id}', [Superadmin_Consumable_Out_Controller::class, 'create']);
        Route::post('/superadmin_consumable/barang_keluar/post/{id}', [Superadmin_Consumable_Out_Controller::class, 'store']);
        Route::get('/superadmin_consumable/show_barang_keluar/{id}/{it}', [Superadmin_Consumable_Out_Controller::class, 'show']);
        Route::put('/superadmin_consumable/update_barang_keluar/{id}/{it}', [Superadmin_Consumable_Out_Controller::class, 'update']);
        Route::delete('/superadmin_consumable/consumable/keluar/{id}', [Superadmin_Consumable_Out_Controller::class, 'destroy']);
        Route::get('/superadmin_consumable/print_barang_keluar/{id}/{tglawal}&{tglakhir}', [Superadmin_Consumable_Out_Controller::class, 'print']);

        // Superadmin Inventaris
        Route::get('/superadmin_inventaris/inventaris/{id}', [Superadmin_Inventaris_Controller::class, 'index']);
        Route::get('/superadmin_inventaris/inventaris/get_data/{id}', [Superadmin_Inventaris_Controller::class, 'get_data']);
        Route::get('/superadmin_inventaris/print_all/{id}/{tglawal}&{tglakhir}', [Superadmin_Inventaris_Controller::class, 'print']);
        Route::get('/superadmin_inventaris/show/{id}/{it}', [Superadmin_Inventaris_Controller::class, 'show']);
        Route::get('/superadmin_inventaris/gambar/{id}', [Superadmin_Inventaris_Controller::class, 'gambar']);

        // Inventaris Barang
        Route::get('/superadmin_inventaris/inventaris/barang/{id}', [Superadmin_Inventaris_Barang_Controller::class, 'index']);
        Route::get('/superadmin_inventaris/inventaris/create/{id}', [Superadmin_Inventaris_Barang_Controller::class, 'create']);
        Route::post('/superadmin_inventaris_barang/post/{id}', [Superadmin_Inventaris_Barang_Controller::class, 'store']);
        Route::get('/superadmin_inventaris_barang/show/{id}/{it}', [Superadmin_Inventaris_Barang_Controller::class, 'show']);
        Route::put('/superadmin_inventaris_barang/update/{id}/{it}', [Superadmin_Inventaris_Barang_Controller::class, 'update']);
        Route::delete('/superadmin_inventaris_barang/delete/{id}/{it}', [Superadmin_Inventaris_Barang_Controller::class, 'destroy']);
        // Inventaris Masuk
        Route::get('/superadmin_inventaris/inventaris/masuk/{id}', [Superadmin_Inventaris_In_Controller::class, 'index']);
        Route::get('/superadmin_inventaris/inventaris/masuk/get_data/{id}', [Superadmin_Inventaris_In_Controller::class, 'get_data']);
        Route::get('/superadmin_inventaris/cari_barang/{id}', [Superadmin_Inventaris_In_Controller::class, 'cari_barang']);
        Route::get('/superadmin_inventaris/add_barang_masuk/{id}', [Superadmin_Inventaris_In_Controller::class, 'create']);
        Route::post('/superadmin_inventaris/barang_masuk/post/{id}', [Superadmin_Inventaris_In_Controller::class, 'store']);
        Route::get('/superadmin_inventaris/show_barang_masuk/{id}/{it}', [Superadmin_Inventaris_In_Controller::class, 'show']);
        Route::put('/superadmin_inventaris/update_barang_masuk/{id}/{it}', [Superadmin_Inventaris_In_Controller::class, 'update']);
        Route::delete('/superadmin_inventaris/inventaris/masuk/{id}', [Superadmin_Inventaris_In_Controller::class, 'destroy']);
        Route::get('/superadmin_inventaris/print_barang_masuk/{id}/{tglawal}&{tglakhir}', [Superadmin_Inventaris_In_Controller::class, 'print']);
        Route::get('/inventaris/view_gambar/{id}', [Superadmin_Inventaris_In_Controller::class, 'gambar']);
        // Inventaris Keluar
        Route::get('/superadmin_inventaris/inventaris/keluar/{id}', [Superadmin_Inventaris_Out_Controller::class, 'index']);
        Route::get('/superadmin_inventaris/inventaris/keluar/get_data/{id}', [Superadmin_Inventaris_Out_Controller::class, 'get_data']);
        Route::get('/superadmin_inventaris/keluar/cari_barang/{id}', [Superadmin_Inventaris_Out_Controller::class, 'cari_barang']);
        Route::get('/superadmin_inventaris/add_barang_keluar/{id}', [Superadmin_Inventaris_Out_Controller::class, 'create']);
        Route::post('/superadmin_inventaris/barang_keluar/post/{id}', [Superadmin_Inventaris_Out_Controller::class, 'store']);
        Route::get('/superadmin_inventaris/show_barang_keluar/{id}/{it}', [Superadmin_Inventaris_Out_Controller::class, 'show']);
        Route::put('/superadmin_inventaris/update_barang_keluar/{id}/{it}', [Superadmin_Inventaris_Out_Controller::class, 'update']);
        Route::delete('/superadmin_inventaris/inventaris/keluar/{id}', [Superadmin_Inventaris_Out_Controller::class, 'destroy']);
        Route::get('/superadmin_inventaris/print_barang_keluar/{id}/{tglawal}&{tglakhir}', [Superadmin_Inventaris_Out_Controller::class, 'print']);
        // Inventaris Perawatan
        Route::get('/superadmin_inventaris/perawatan/{id}', [Superadmin_Inventaris_Perawatan_Controller::class, 'index']);
        Route::get('/superadmin_inventaris/perawatan/get_data/{id}', [Superadmin_Inventaris_Perawatan_Controller::class, 'get_data']);
        Route::get('/superadmin_inventaris/perawatan/cari_barang/{id}', [Superadmin_Inventaris_Perawatan_Controller::class, 'cari_barang']);
        Route::get('/superadmin_inventaris/add_perawatan/{id}', [Superadmin_Inventaris_Perawatan_Controller::class, 'create']);
        Route::post('/superadmin_inventaris/perawatan/post/{id}', [Superadmin_Inventaris_Perawatan_Controller::class, 'store']);
        Route::get('/superadmin_inventaris/perawatan/show/{id}/{it}', [Superadmin_Inventaris_Perawatan_Controller::class, 'show']);
        Route::put('/superadmin_inventaris/update_perawatan/{id}/{it}', [Superadmin_Inventaris_Perawatan_Controller::class, 'update']);
        Route::delete('/superadmin_inventaris/perawatan/{id}', [Superadmin_Inventaris_Perawatan_Controller::class, 'destroy']);
        Route::get('/superadmin_inventaris/print_perawatan/{id}/{tglawal}&{tglakhir}', [Superadmin_Inventaris_Perawatan_Controller::class, 'print']);
        Route::put('/superadmin_inventaris/update_riwayat_perawatan/{id}', [Superadmin_Inventaris_Perawatan_Riwayat_Controller::class, 'update']);
        Route::delete('/superadmin_inventaris/riwayat_perawatan/{id}', [Superadmin_Inventaris_Perawatan_Riwayat_Controller::class, 'destroy']);

        // superadmin Kendaraan
        Route::get('/superadmin_kendaraan/kendaraan/{id}', [Superadmin_Kendaraan_Controller::class, 'index']);
        Route::get('/superadmin_kendaraan/kendaraan/get_data/{id}', [Superadmin_Kendaraan_Controller::class, 'get_data']);
        Route::get('/superadmin_kendaraan/print_all/{id}/{tglawal}&{tglakhir}', [Superadmin_Kendaraan_Controller::class, 'print']);
        Route::get('/superadmin_kendaraan/show/{id}/{it}', [Superadmin_Kendaraan_Controller::class, 'show']);
        Route::get('/superadmin_kendaraan/gambar/{id}', [Superadmin_Kendaraan_Controller::class, 'gambar']);

        // Data Kendaraan
        Route::get('/superadmin_kendaraan/kendaraan/index/{id}', [Superadmin_Data_Kendaraan_Controller::class, 'index']);
        Route::get('/superadmin_kendaraan/kendaraan/add/{id}', [Superadmin_Data_Kendaraan_Controller::class, 'create']);
        Route::post('/superadmin_kendaraan/kendaraan/post/{id}', [Superadmin_Data_Kendaraan_Controller::class, 'store']);
        Route::get('/superadmin_kendaraan/kendaraan/show/{id}/{it}', [Superadmin_Data_Kendaraan_Controller::class, 'show']);
        Route::put('/superadmin_kendaraan/kendaraan/update/{id}/{it}', [Superadmin_Data_Kendaraan_Controller::class, 'update']);
        Route::delete('/superadmin_kendaraan/kendaraan/delete/{id}/{it}', [Superadmin_Data_Kendaraan_Controller::class, 'destroy']);
        // Kendaraan Masuk
        Route::get('/superadmin_kendaraan/kendaraan/masuk/{id}', [Superadmin_Kendaraan_In_Controller::class, 'index']);
        Route::get('/superadmin_kendaraan/kendaraan/masuk/get_data/{id}', [Superadmin_Kendaraan_In_Controller::class, 'get_data']);
        Route::get('/superadmin_kendaraan/cari_barang/{id}', [Superadmin_Kendaraan_In_Controller::class, 'cari_barang']);
        Route::get('/superadmin_kendaraan/add_barang_masuk/{id}', [Superadmin_Kendaraan_In_Controller::class, 'create']);
        Route::post('/superadmin_kendaraan/barang_masuk/post/{id}', [Superadmin_Kendaraan_In_Controller::class, 'store']);
        Route::get('/superadmin_kendaraan/show_barang_masuk/{id}/{it}', [Superadmin_Kendaraan_In_Controller::class, 'show']);
        Route::put('/superadmin_kendaraan/update_barang_masuk/{id}/{it}', [Superadmin_Kendaraan_In_Controller::class, 'update']);
        Route::delete('/superadmin_kendaraan/kendaraan/masuk/{id}', [Superadmin_Kendaraan_In_Controller::class, 'destroy']);
        Route::get('/superadmin_kendaraan/print_barang_masuk/{id}/{tglawal}&{tglakhir}', [Superadmin_Kendaraan_In_Controller::class, 'print']);
        Route::get('/kendaraan/view_gambar/{id}', [Superadmin_Kendaraan_In_Controller::class, 'gambar']);
        // Kendaraan Keluar
        Route::get('/superadmin_kendaraan/kendaraan/keluar/{id}', [Superadmin_Kendaraan_Out_Controller::class, 'index']);
        Route::get('/superadmin_kendaraan/kendaraan/keluar/get_data/{id}', [Superadmin_Kendaraan_Out_Controller::class, 'get_data']);
        Route::get('/superadmin_kendaraan/keluar/cari_barang/{id}', [Superadmin_Kendaraan_Out_Controller::class, 'cari_barang']);
        Route::get('/superadmin_kendaraan/add_barang_keluar/{id}', [Superadmin_Kendaraan_Out_Controller::class, 'create']);
        Route::post('/superadmin_kendaraan/barang_keluar/post/{id}', [Superadmin_Kendaraan_Out_Controller::class, 'store']);
        Route::get('/superadmin_kendaraan/show_barang_keluar/{id}/{it}', [Superadmin_Kendaraan_Out_Controller::class, 'show']);
        Route::put('/superadmin_kendaraan/update_barang_keluar/{id}/{it}', [Superadmin_Kendaraan_Out_Controller::class, 'update']);
        Route::delete('/superadmin_kendaraan/kendaraan/keluar/{id}', [Superadmin_Kendaraan_Out_Controller::class, 'destroy']);
        Route::get('/superadmin_kendaraan/print_barang_keluar/{id}/{tglawal}&{tglakhir}', [Superadmin_Kendaraan_Out_Controller::class, 'print']);
        // Kendaraan Servis
        Route::get('/superadmin_servis/kendaraan/{id}', [Superadmin_Kendaraan_Servis_Controller::class, 'index']);
        Route::get('/superadmin_servis/kendaraan/get_data/{id}', [Superadmin_Kendaraan_Servis_Controller::class, 'get_data']);
        Route::get('/superadmin_servis/cari_barang/{id}', [Superadmin_Kendaraan_Servis_Controller::class, 'cari_barang']);
        Route::get('/superadmin_servis/add_servis/{id}', [Superadmin_Kendaraan_Servis_Controller::class, 'create']);
        Route::post('/superadmin_servis/add_servis/post/{id}', [Superadmin_Kendaraan_Servis_Controller::class, 'store']);
        Route::get('/superadmin_servis/show/{id}/{it}', [Superadmin_Kendaraan_Servis_Controller::class, 'show']);
        // Route::put('/superadmin_kendaraan/update_barang_keluar/{id}/{it}', [Superadmin_Kendaraan_Out_Controller::class, 'update']);
        Route::delete('/superadmin_servis/kendaraan/{id}', [Superadmin_Kendaraan_Servis_Controller::class, 'destroy']);
        // Route::get('/superadmin_kendaraan/print_barang_keluar/{id}/{tglawal}&{tglakhir}', [Superadmin_Kendaraan_Out_Controller::class, 'print']);
        Route::post('/superadmin_servis/add_riwayat_servis/post/{id}', [Superadmin_Kendaraan_Servis_Riwayat_Controller::class, 'store']);
        Route::put('/superadmin_kendaraan/update_riwayat_servis/{id}', [Superadmin_Kendaraan_Servis_Riwayat_Controller::class, 'update']);
        Route::delete('/superadmin_kendaraa/riwayat_servis/{id}', [Superadmin_Kendaraan_Servis_Riwayat_Controller::class, 'destroy']);
        // Kendaraan Pajak
        Route::get('/superadmin_pajak/pajak/{id}', [Superadmin_Kendaraan_Pajak_Controller::class, 'index']);
        Route::get('/superadmin_pajak/pajak/get_data/{id}', [Superadmin_Kendaraan_Pajak_Controller::class, 'get_data']);
        Route::get('/superadmin_pajak/cari_barang/{id}', [Superadmin_Kendaraan_Pajak_Controller::class, 'cari_barang']);
        Route::post('/superadmin_pajak/add_pajak/post/{id}', [Superadmin_Kendaraan_Pajak_Controller::class, 'store']);
        Route::get('/superadmin_pajak/show/{id}/{it}', [Superadmin_Kendaraan_Pajak_Controller::class, 'show']);
        Route::put('/superadmin_pajak/update_pajak/{id}', [Superadmin_Kendaraan_Pajak_Controller::class, 'update']);
        Route::delete('/superadmin_pajak/delete/{id}', [Superadmin_Kendaraan_Pajak_Controller::class, 'destroy']);
        // Route::post('/superadmin_kendaraan/update_riwayat_pajak/{id}', [Superadmin_Kendaraan_Pajak_Riwayat_Controller::class, 'store']);
        Route::put('/superadmin_kendaraan/update_riwayat_pajak/{id}', [Superadmin_Kendaraan_Pajak_Riwayat_Controller::class, 'update']);
        Route::delete('/superadmin_kendaraa/riwayat_pajak/{id}', [Superadmin_Kendaraan_Pajak_Riwayat_Controller::class, 'destroy']);
    });

    // Kategori
    Route::resource('/superadmin_master_kategori', Kategori_Controller::class);

    // Route::resource('/superadmin_consumable_barang', Superadmin_Consumable_Barang_Controller::class);
    // Route::post('/superadmin_consumable/consumable/barang/{id}', [Superadmin_Consumable_Barang_Controller::class, 'store']);

    // Konstruksi
    // Barang Masuk
    Route::resource('/sa_master_konstruksi_in_barang', Superadmin_Gs_Konstruksi_In_Barang_Controller::class);
    Route::get('/sa_master_konstruksi_in_barang/barang_masuk/show_data/', [Superadmin_Gs_Konstruksi_In_Barang_Controller::class, 'show_data'])->name('barang.masuk');
    Route::get('/sa_master_konstruksi_in_barang/add_barang/{id}', [Superadmin_Gs_Konstruksi_In_Barang_Controller::class, 'add_barang']);
    Route::get('/sa_master_konstruksi_in_barang/gambar/{id}', [Superadmin_Gs_Konstruksi_In_Barang_Controller::class, 'gambar']);
    Route::get('/bms_aset/print/{tglawal}&{tglakhir}', [Superadmin_Gs_Konstruksi_In_Barang_Controller::class, 'print']);
    // Barang Keluar
    Route::resource('/sa_master_konstruksi_out_barang', Superadmin_Gs_Konstruksi_Out_Barang_Controller::class);
    Route::get('/sa_master_konstruksi_out_barang/barang_keluar/show_data', [Superadmin_Gs_Konstruksi_Out_Barang_Controller::class, 'show_data'])->name('barang.keluar');
    Route::get('/sa_master_konstruksi_out_barang/add_barang/{id}', [Superadmin_Gs_Konstruksi_Out_Barang_Controller::class, 'add_barang']);
    Route::get('/bms_aset/print_out/{tglawal}&{tglakhir}', [Superadmin_Gs_Konstruksi_Out_Barang_Controller::class, 'print']);
    // Stok Barang Konstruksi
    Route::resource('/sa_master_konstruksi_stok_barang', Superadmin_Gs_Konstruksi_Stok_Barang_Controller::class);
    Route::get('/sa_master_konstruksi_stok_barang/show/{id}', [Superadmin_Gs_Konstruksi_Stok_Barang_Controller::class, 'show']);
    Route::get('/sa_master_konstruksi_stok_barang/lap_stok_barang/show_data', [Superadmin_Gs_Konstruksi_Stok_Barang_Controller::class, 'show_data'])->name('lap.stok.barang');
    // Route::get('/bms_aset/print_all/{tglawal}&{tglakhir}', [Superadmin_Gs_Konstruksi_Stok_Barang_Controller::class, 'print']);

    // Produksi
    // Barang Produksi
    Route::resource('/sa_master_gs_produksi_barang', Superadmin_Gs_Produksi_Barang_Controller::class);
    // Barang Masuk
    Route::resource('/sa_master_produksi_in_barang', Superadmin_Gs_Produksi_In_Barang_Controller::class);
    Route::get('/sa_master_produksi_in_barang/barang_masuk/show_data', [Superadmin_Gs_Produksi_In_Barang_Controller::class, 'show_data'])->name('produksi.barang.masuk');
    Route::get('/sa_master_produksi_in_barang/add_barang/{id}', [Superadmin_Gs_Produksi_In_Barang_Controller::class, 'add_barang']);
    Route::get('/sa_master_produksi_in_barang/gambar/{id}', [Superadmin_Gs_Produksi_In_Barang_Controller::class, 'gambar']);
    Route::get('/bms_aset_produksi/print/{tglawal}&{tglakhir}', [Superadmin_Gs_Produksi_In_Barang_Controller::class, 'print']);
    // Route::get('/bms_aset/print_all/{tglawal}&{tglakhir}', [Superadmin_Gs_produksi_Stok_Barang_Controller::class, 'print']);
    // Barang Keluar
    Route::resource('/sa_master_produksi_out_barang', Superadmin_Gs_Produksi_Out_Barang_Controller::class);
    Route::get('/sa_master_produksi_out_barang/barang_keluar/show_data', [Superadmin_Gs_Produksi_Out_Barang_Controller::class, 'show_data'])->name('produksi.barang.keluar');
    Route::get('/sa_master_produksi_out_barang/add_barang/{id}', [Superadmin_Gs_Produksi_Out_Barang_Controller::class, 'add_barang']);
    Route::get('/bms_aset_produksi/print_out/{tglawal}&{tglakhir}', [Superadmin_Gs_Produksi_Out_Barang_Controller::class, 'print']);
    // Stok Barang produksi
    Route::resource('/sa_master_produksi_stok_barang', Superadmin_Gs_Produksi_Stok_Barang_Controller::class);
    Route::get('/sa_master_produksi_stok_barang/show/{id}', [Superadmin_Gs_Produksi_Stok_Barang_Controller::class, 'show']);
    Route::get('/sa_master_produksi_stok_barang/lap_stok_barang/show_data', [Superadmin_Gs_Produksi_Stok_Barang_Controller::class, 'show_data'])->name('produksi.lap.stok.barang');
    Route::get('/bms_aset_produksi/print_all/{tglawal}&{tglakhir}', [Superadmin_Gs_Produksi_Stok_Barang_Controller::class, 'print']);
});

Route::group(['middleware' => 'auth'], function () {
    Route::middleware(['admin'])->group(function () {
        Route::resource('/admin', Admin_Area_Controller::class);
        Route::resource('/admin_menu', Admin_Menu_Controller::class);
        Route::resource('/master_kategori', Admin_Kategori_Controller::class);
        Route::resource('/admin_profil', Admin_Profil_Controller::class);

        // Consumable
        Route::get('/consumable/{id}', [Consumable_Controller::class, 'index']);
        Route::get('/consumable/get_data/{id}', [Consumable_Controller::class, 'get_data']);
        Route::get('/consumable/print_all/{id}/{tglawal}&{tglakhir}', [Consumable_Controller::class, 'print']);
        Route::get('/consumable/show/{id}/{it}', [Consumable_Controller::class, 'show']);
        Route::get('/consumable/gambar/{id}', [Consumable_Controller::class, 'gambar']);

        // Consumbale Barang
        Route::get('/consumable/consumable/barang/{id}', [Consumable_Barang_Controller::class, 'index']);
        Route::get('/consumable/consumable/get_data/{id}', [Consumable_Barang_Controller::class, 'get_data']);
        Route::get('/consumable/consumable/create/{id}', [Consumable_Barang_Controller::class, 'create']);
        Route::post('/consumable_barang/post/{id}', [Consumable_Barang_Controller::class, 'store']);
        Route::get('/consumable_barang/show/{id}/{it}', [Consumable_Barang_Controller::class, 'show']);
        Route::put('/consumable_barang/update/{id}/{it}', [Consumable_Barang_Controller::class, 'update']);
        Route::delete('/consumable_barang/delete/{id}', [Consumable_Barang_Controller::class, 'destroy']);

        // Consumbale Masuk
        Route::get('/consumable/consumable/masuk/{id}', [Consumable_In_Controller::class, 'index']);
        Route::get('/consumable/consumable/masuk/get_data/{id}', [Consumable_In_Controller::class, 'get_data']);
        Route::get('/consumable/cari_barang/{id}', [Consumable_In_Controller::class, 'cari_barang']);
        Route::get('/consumable/masuk/get_data_barang/{id}', [Consumable_In_Controller::class, 'get_data_barang']);
        Route::get('/consumable/add_barang_masuk/{id}', [Consumable_In_Controller::class, 'create']);
        Route::get('/consumable_pencarian/{id}', [Consumable_In_Controller::class, 'search']);
        Route::get('/consumable_data_barang/{id}', [Consumable_In_Controller::class, 'data_barang']);
        Route::post('/consumable/barang_masuk/post/{id}', [Consumable_In_Controller::class, 'store']);
        Route::get('/consumable/show_barang_masuk/{id}/{it}', [Consumable_In_Controller::class, 'show']);
        Route::put('/consumable/update_barang_masuk/{id}/{it}', [Consumable_In_Controller::class, 'update']);
        Route::delete('/consumable/consumable/masuk/{id}', [Consumable_In_Controller::class, 'destroy']);
        Route::get('/consumable/print_barang_masuk/{id}/{tglawal}&{tglakhir}', [Consumable_In_Controller::class, 'print']);
        Route::get('/consumable_masuk/view_gambar/{id}', [Consumable_In_Controller::class, 'gambar']);
        // Consumbale Keluar
        Route::get('/consumable/consumable/keluar/{id}', [Consumable_Out_Controller::class, 'index']);
        Route::get('/consumable/consumable/keluar/get_data/{id}', [Consumable_Out_Controller::class, 'get_data']);
        Route::get('/consumable/keluar/cari_barang/{id}', [Consumable_Out_Controller::class, 'cari_barang']);
        Route::get('/consumable_pencarian_keluar/{id}', [Consumable_Out_Controller::class, 'search']);
        Route::get('/consumable_data_barang_keluar/{id}', [Consumable_Out_Controller::class, 'data_barang']);
        Route::get('/consumable/keluar/get_data_barang/{id}', [Consumable_Out_Controller::class, 'get_data_barang']);
        Route::get('/consumable/add_barang_keluar/{id}', [Consumable_Out_Controller::class, 'create']);
        Route::post('/consumable/barang_keluar/post/{id}', [Consumable_Out_Controller::class, 'store']);
        Route::get('/consumable/show_barang_keluar/{id}/{it}', [Consumable_Out_Controller::class, 'show']);
        Route::put('/consumable/update_barang_keluar/{id}/{it}', [Consumable_Out_Controller::class, 'update']);
        Route::delete('/consumable/consumable/keluar/{id}', [Consumable_Out_Controller::class, 'destroy']);
        Route::get('/consumable/print_barang_keluar/{id}/{tglawal}&{tglakhir}', [Consumable_Out_Controller::class, 'print']);

        // Inventaris
        Route::get('/inventaris/inventaris/{id}', [Inventaris_Controller::class, 'index']);
        Route::get('/inventaris/get_data/{id}', [Inventaris_Controller::class, 'get_data']);
        Route::get('/inventaris/print_all/{id}/{tglawal}&{tglakhir}', [Inventaris_Controller::class, 'print']);
        Route::get('/inventaris/show/{id}/{it}', [Inventaris_Controller::class, 'show']);
        Route::get('/inventaris/gambar/{id}', [Inventaris_Controller::class, 'gambar']);
        // Inventaris Barang
        Route::get('/inventaris/inventaris/barang/{id}', [Inventaris_Barang_Controller::class, 'index']);
        Route::get('/inventaris/inventaris/get_data/{id}', [Inventaris_Barang_Controller::class, 'get_data']);
        Route::get('/inventaris/inventaris/create/{id}', [Inventaris_Barang_Controller::class, 'create']);
        Route::post('/inventaris_barang/post/{id}', [Inventaris_Barang_Controller::class, 'store']);
        Route::get('/inventaris_barang/show/{id}/{it}', [Inventaris_Barang_Controller::class, 'show']);
        Route::put('/inventaris_barang/update/{id}/{it}', [Inventaris_Barang_Controller::class, 'update']);
        Route::delete('/inventaris_barang/delete/{id}', [Inventaris_Barang_Controller::class, 'destroy']);
        // Inventaris Masuk
        Route::get('/inventaris/inventaris/masuk/{id}', [Inventaris_In_Controller::class, 'index']);
        Route::get('/inventaris/inventaris/masuk/get_data/{id}', [Inventaris_In_Controller::class, 'get_data']);
        Route::get('/inventaris/cari_barang/{id}', [Inventaris_In_Controller::class, 'cari_barang']);
        Route::get('/inventaris_pencarian/{id}', [Inventaris_In_Controller::class, 'search']);
        Route::get('/inventaris_data_barang/{id}', [Inventaris_In_Controller::class, 'data_barang']);
        Route::get('/inventaris/add_barang_masuk/{id}', [Inventaris_In_Controller::class, 'create']);
        Route::post('/inventaris/barang_masuk/post/{id}', [Inventaris_In_Controller::class, 'store']);
        Route::get('/inventaris/show_barang_masuk/{id}/{it}', [Inventaris_In_Controller::class, 'show']);
        Route::put('/inventaris/update_barang_masuk/{id}/{it}', [Inventaris_In_Controller::class, 'update']);
        Route::delete('/inventaris/inventaris/masuk/{id}', [Inventaris_In_Controller::class, 'destroy']);
        Route::get('/inventaris/print_barang_masuk/{id}/{tglawal}&{tglakhir}', [Inventaris_In_Controller::class, 'print']);
        Route::get('/inventaris_masuk/view_gambar/{id}', [Inventaris_In_Controller::class, 'gambar']);
        // Inventaris Keluar
        Route::get('/inventaris/inventaris/keluar/{id}', [Inventaris_Out_Controller::class, 'index']);
        Route::get('/inventaris/inventaris/keluar/get_data/{id}', [Inventaris_Out_Controller::class, 'get_data']);
        Route::get('/inventaris/keluar/cari_barang/{id}', [Inventaris_Out_Controller::class, 'cari_barang']);
        Route::get('/inventaris_pencarian_keluar/{id}', [Inventaris_Out_Controller::class, 'search']);
        Route::get('/inventaris_data_barang_keluar/{id}', [Inventaris_Out_Controller::class, 'data_barang']);
        Route::get('/inventaris/add_barang_keluar/{id}', [Inventaris_Out_Controller::class, 'create']);
        Route::post('/inventaris/barang_keluar/post/{id}', [Inventaris_Out_Controller::class, 'store']);
        Route::get('/inventaris/show_barang_keluar/{id}/{it}', [Inventaris_Out_Controller::class, 'show']);
        Route::put('/inventaris/update_barang_keluar/{id}/{it}', [Inventaris_Out_Controller::class, 'update']);
        Route::delete('/inventaris/inventaris/keluar/{id}', [Inventaris_Out_Controller::class, 'destroy']);
        Route::get('/inventaris/print_barang_keluar/{id}/{tglawal}&{tglakhir}', [Inventaris_Out_Controller::class, 'print']);
        // Inventaris Perawatan
        Route::get('/inventaris/perawatan/{id}', [Inventaris_Perawatan_Controller::class, 'index']);
        Route::get('/inventaris/perawatan/get_data/{id}', [Inventaris_Perawatan_Controller::class, 'get_data']);
        Route::get('/inventaris/perawatan/cari_barang/{id}', [Inventaris_Perawatan_Controller::class, 'cari_barang']);
        Route::get('/inventaris_data_perawatan/get_data/{id}', [Inventaris_Perawatan_Controller::class, 'data_barang']);
        // Route::get('/inventaris_pencarian_perawatan/{id}', [Inventaris_Perawatan_Controller::class, 'search']);
        Route::get('/inventaris/add_perawatan/{id}', [Inventaris_Perawatan_Controller::class, 'create']);
        Route::post('/inventaris/perawatan/post/{id}', [Inventaris_Perawatan_Controller::class, 'store']);
        Route::get('/inventaris/perawatan/show/{id}/{it}', [Inventaris_Perawatan_Controller::class, 'show']);
        Route::put('/inventaris/update_perawatan/{id}/{it}', [Inventaris_Perawatan_Controller::class, 'update']);
        Route::delete('/inventaris/perawatan/{id}', [Inventaris_Perawatan_Controller::class, 'destroy']);
        Route::get('/inventaris/print_perawatan/{id}/{tglawal}&{tglakhir}', [Inventaris_Perawatan_Controller::class, 'print']);
        Route::put('/inventaris_riwayat/update_riwayat_perawatan/{id}', [Inventaris_Perawatan_Riwayat_Controller::class, 'update']);
        Route::delete('/inventaris_riwayat/riwayat_perawatan/{id}', [Inventaris_Perawatan_Riwayat_Controller::class, 'destroy']);

         // superadmin Kendaraan
         Route::get('/kendaraan/kendaraan/{id}', [Kendaraan_Controller::class, 'index']);
         Route::get('/kendaraan/kendaraan/get_data/{id}', [Kendaraan_Controller::class, 'get_data']);
         Route::get('/kendaraan/print_all/{id}/{tglawal}&{tglakhir}', [Kendaraan_Controller::class, 'print']);
         Route::get('/kendaraan/show/{id}/{it}', [Kendaraan_Controller::class, 'show']);
         Route::get('/kendaraan/gambar/{id}', [Kendaraan_Controller::class, 'gambar']);

         // Data Kendaraan
        Route::get('/kendaraan/kendaraan/index/{id}', [Data_Kendaraan_Controller::class, 'index']);
        Route::get('/kendaraan/data_kendaraan/get_data/{id}', [Data_Kendaraan_Controller::class, 'get_data']);
        Route::get('/kendaraan/kendaraan/create/{id}', [Data_Kendaraan_Controller::class, 'create']);
        Route::post('/kendaraan/kendaraan/post/{id}', [Data_Kendaraan_Controller::class, 'store']);
        Route::get('/kendaraan/kendaraan/show/{id}/{it}', [Data_Kendaraan_Controller::class, 'show']);
        Route::put('/kendaraan/kendaraan/update/{id}/{it}', [Data_Kendaraan_Controller::class, 'update']);
        Route::delete('/kendaraan/delete/{id}', [Data_Kendaraan_Controller::class, 'destroy']);
          // Kendaraan Masuk
          Route::get('/kendaraan/kendaraan/masuk/{id}', [Kendaraan_In_Controller::class, 'index']);
          Route::get('/kendaraan/kendaraan/masuk/get_data/{id}', [Kendaraan_In_Controller::class, 'get_data']);
          Route::get('/kendaraan/cari_barang/{id}', [Kendaraan_In_Controller::class, 'cari_barang']);
          Route::get('/kendaraan_pencarian/{id}', [Kendaraan_In_Controller::class, 'search']);
        Route::get('/kendaraan_data_barang/{id}', [Kendaraan_In_Controller::class, 'data_barang']);
          Route::get('/kendaraan/add_barang_masuk/{id}', [Kendaraan_In_Controller::class, 'create']);
          Route::post('/kendaraan/barang_masuk/post/{id}', [Kendaraan_In_Controller::class, 'store']);
          Route::get('/kendaraan/show_barang_masuk/{id}/{it}', [Kendaraan_In_Controller::class, 'show']);
          Route::put('/kendaraan/update_barang_masuk/{id}/{it}', [Kendaraan_In_Controller::class, 'update']);
          Route::delete('/kendaraan/kendaraan/masuk/{id}', [Kendaraan_In_Controller::class, 'destroy']);
          Route::get('/kendaraan/print_barang_masuk/{id}/{tglawal}&{tglakhir}', [Kendaraan_In_Controller::class, 'print']);
          Route::get('/kendaraan/view_gambar/{id}', [Kendaraan_In_Controller::class, 'gambar']);
    
 
    });
});

// Get
Route::get('getdivisi', [Get_Controller::class, 'getdivisi'])->name('getdivisi');
Route::get('getproyek', [Get_Controller::class, 'getproyek'])->name('getproyek');
Route::get('getsubdivisi', [Get_Controller::class, 'getsubdivisi'])->name('getsubdivisi');

// Gambar

Route::get('/color', function () {
    return view('color');
});
