@extends('layouts.index')

@section('main')
    <div class="pc-content">
        <div class="page-header">
            <div class="page-block">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <div class="">

                            <div class="page-header-title">
                                {{-- <h5 class="m-b-10">Tabler Icons</h5> --}}
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a class="text-decoration-none" href="/superadmin_1">Home</a>
                                </li>
                                <li class="breadcrumb-item"><a class="text-decoration-none" href="#">{{ $menu }}</a></li>
                                <li class="breadcrumb-item" aria-current="page">{{ $nama_menu }}</li>
                            </ul>

                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">

                <div class="shadow bg-light col-sm-6 p-3 " style="border-radius: 20px">
                    <div class="d-flex justify-content-between  mt-2">
                        <div class="d-flex text-center">
                            {{-- <img src="{{ asset('images/logo-1.png') }}" width="45" height="45" alt=""> --}}
                            <p class="fs-6 teks fw-bold"><i class="bi bi-ui-checks-grid "></i> Tambah Proyek</p>
                        </div>

                    </div>
                    {{-- <div class=" ">
            <h5 class="text-success">Total = <span class="fw-bold">Rp.1.000.000.000</span> </h5>
        </div> --}}
                    {{-- <hr class="mt-0 p-1 bg-primary rounded" width="350" ></hr> --}}
                    <form action="/superadmin_master_proyek" method="post" enctype="multipart/form-data">
                        @csrf

                        <div class="">
                            <div class="mb-3">
                                <label for="perusahaan" class=" mb-0 teks"><i class="bi bi-dropbox"></i>
                                    Perusahaan</label>
                                <select class="shadow-sm form-select form-select-sm rounded-pill" name="perusahaan_id"
                                    id="perusahaan" value="{{ old('perusahaan_id') }}">
                                    <option selected disabled>-- Pilih Perusahaan -- </option>
                                    @foreach ($perusahaan as $item)
                                        <option id="perusahaan" value="{{ $item->id }}">-
                                            {{ $item->nama_perusahaan }}</option>
                                    @endforeach
                                </select>
                                @error('perusahaan_id')
                                    <div class="teks-notif text-danger">
                                        <span class="ps-3 fst-italic"><i class="bi bi-info-circle"></i> Perusahaan
                                            wajib di pilih !</span>
                                    </div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label for="divisi" class=" mb-0 teks"><i class="bi bi-dropbox"></i>
                                    Divisi</label>
                                <select class="shadow-sm form-select form-select-sm rounded-pill" name="divisi_id"
                                    id="divisi">
                                    <option value="">-- Pilih Divisi --</option>
                                </select>
                                @error('divisi_id')
                                    <div class="teks-notif text-danger">
                                        <span class="ps-3 fst-italic"><i class="bi bi-info-circle"></i> Divisi
                                            wajib di pilih !</span>
                                    </div>
                                @enderror
                            </div>
                          
                                <div class="mb-3">
                                    <label for="nama_proyek" class="form-label teks mb-0"><i class="bi bi-houses"></i> Nama Proyek</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('nama_proyek') is-invalid @enderror "
                                        name="nama_proyek" required autofocus value="{{ old('nama_proyek') }}"  onkeyup="this.value = this.value.toUpperCase()">
                                    @error('nama_proyek')
                                        <div class="text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Kategori sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>


                                

                           


                        </div>



                        <div class="d-flex justify-content-around mt-4">
                            <button type="submit" class="shadow btn btn-primary btn-sm col-3  rounded-pill mb-5">Simpan</button>
                            <a href="" onclick="goBack()" class="shadow btn btn-danger btn-sm col-3 mb-5 rounded-pill ">Batal</a>

                        </div>

                    </form>

                </div>
            </div>
        </div>





    </div>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script>
        $(function() {
            $('#perusahaan').on('change', function() {
                let id_perusahaan = $('#perusahaan').val();

                console.log(id_perusahaan);
                $.ajax({
                    type: 'get',
                    url: "{{ route('getdivisi') }}",
                    data: {
                        id_perusahaan: id_perusahaan
                    },
                    cache: false,

                    success: function(msg) {
                        $('#divisi').html(msg);
                    },
                    error: function(data) {
                        console.log('error: ', data);

                    }
                })
            })
        })
    </script>

    {{-- <script>
        const judul = document.querySelector('#judul')
        const slug = document.querySelector('#slug')

        judul.addEventListener('change', function() {
            fetch('/adminberita/checkSlug?judul=' + judul.value);
            .then(response => response.json())
                .then(data => slug.value = data.slug)
        })
    </script> --}}
@endsection
