@extends('layouts.index')

@section('main')
    <div class="pc-content">
        <!-- [ breadcrumb ] start -->
        <div class="page-header">
            <div class="page-block">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <div class="">

                            <div class="page-header-title">
                                {{-- <h5 class="m-b-10">Tabler Icons</h5> --}}
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a class="text-decoration-none" href="">Home</a>
                                </li>

                                <li class="breadcrumb-item" aria-current="page"><a
                                        href="/superadmin_divisi/{{ $data_data->proyek->divisi->perusahaan->kode_perusahaan }}/divisi">{{ $data_data->proyek->divisi->perusahaan->kode_perusahaan }}</a>
                                </li>
                                <li class="breadcrumb-item" aria-current="page"><a
                                        href="/superadmin_proyek/{{ $data_data->proyek->divisi->perusahaan->kode_perusahaan }}/divisi/{{ $data_data->proyek->id }}">{{ $data_data->proyek->divisi->nama_divisi }}</a>
                                </li>
                                <li class="breadcrumb-item" aria-current="page"><a
                                        href="/superadmin_sub_divisi/{{ $data_data->proyek->divisi->perusahaan->kode_perusahaan }}/{{ $data_data->proyek->divisi->id }}/proyek/{{ $data_data->proyek->id }}">{{ $data_data->proyek->nama_proyek }}</a>
                                </li>
                                <li class="breadcrumb-item" aria-current="page">{{ $data_data->nama_sub_divisi }}</li>
                            </ul>

                        </div>

                    </div>
                </div>
            </div>
        </div>

        <!-- [ breadcrumb ] end -->

        {{-- main --}}
        <div class="row">
            <div class="col-sm-12">
                <div class="card rounded">

                    <div class="d-flex justify-content-between mx-2 py-2">
                        <div class="">
                            <form class="row" action="#">
                                <div class="m-0">
                                    <p class="fs-5 text-primary m-0"><i class="bi bi-house"></i> MENU</p>
                                    <hr class="m-0 text-primary">
                                </div>
                                {{-- <div class="col cont">
                                    <input type="text" name="search" value="{{ request('search') }}"
                                        class="pencarian" placeholder="Cari Divisi ..">
                                </div>
                                <div class="col">
                                    <button type="submit" class="ms-0 tombol_search"><i class="bi bi-search"></i></button>
                                </div> --}}
                            </form>

                        </div>
                        <div class="d-flex align-items-center">
                            <a href="/superadmin_sub_divisi/{{ $data_data->proyek->divisi->perusahaan->kode_perusahaan }}/{{ $data_data->proyek->divisi->id }}/proyek/{{ $data_data->proyek->id }}""
                                class="tombol_kembali text-light"><i class="bi bi-backspace"></i> Kembali</a>
                        </div>
                    </div>

                    <div class="p-3">
                        <div class="row row-cols-1 row-cols-md-3 g-4">
                            <div class="col ">
                                <div class=" menu-1 rounded shadow ">
                                    <a href="/superadmin_kendaraan/kendaraan/index/{{ $data_data->id }}"
                                        class="text-decoration-none ">
                                        <div class="d-flex justify-content-between px-3 ">
                                            <div class="body-icon text-center">
                                                <img src="{{ asset('assets/images/icon/barang.png') }}"
                                                    class="img-icon p-2 rounded" alt="">
                                            </div>
                                            <div class="">
                                                <h5 class="text-primary">Kendaraan</h5>
                                                <h5 class="text-primary"><i class="bi bi-car-front"></i>
                                                    {{ $jumlah_kendaraan }}</h5>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            <div class="col ">
                                <div class=" menu-2 rounded shadow ">
                                    <a href="/superadmin_kendaraan/kendaraan/masuk/{{ $data_data->id }}"
                                        class="text-decoration-none ">
                                        <div class="d-flex justify-content-between px-3 ">
                                            <div class="body-icon-2 text-center">
                                                <img src="{{ asset('assets/images/icon/barang_in.png') }}"
                                                    class="img-icon p-2 rounded" alt="">
                                            </div>
                                            <div class="">
                                                <h5 class="text-success">Kendaraan Masuk</h5>
                                                <h5 class="text-success"></h5>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            <div class="col ">
                                <div class=" menu-3 rounded shadow ">
                                    <a href="/superadmin_kendaraan/kendaraan/keluar/{{ $data_data->id }}"
                                        class="text-decoration-none ">
                                        <div class="d-flex justify-content-between px-3 ">
                                            <div class="body-icon-3 text-center">
                                                <img src="{{ asset('assets/images/icon/barang_out.png') }}"
                                                    class="img-icon p-2 rounded" alt="">
                                            </div>
                                            <div class="">
                                                <h5 class="text-danger">Kendaraan Terpakai</h5>
                                                <h5 class="text-danger"></h5>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            <div class="col ">
                                <div class=" menu-4 rounded shadow ">
                                    <a href="/superadmin_pajak/pajak/{{ $data_data->id }}" class="text-decoration-none ">
                                        <div class="d-flex justify-content-between px-3 ">
                                            <div class="body-icon-4 text-center">
                                                <img src="{{ asset('assets/images/icon/pajak.png') }}"
                                                    class="img-icon p-2 rounded" alt="">
                                            </div>
                                            <div class="">
                                                <h5 class="text-kuning">Pembayaran Pajak</h5>
                                                <div class="row">
                                                    <div class="col">
                                                        @if ($pajak <= 0)
                                                            <h5 class="text-warning"><i class="bi bi-app-indicator"></i>
                                                                {{ $pajak }} </h5>
                                                        @else
                                                            <h5 class="text-danger"><i class="bi bi-app-indicator"></i>
                                                                {{ $pajak }} </h5>
                                                        @endif

                                                    </div>
                                                    <div class="col">
                                                        @if ($stnk <= 0)
                                                            <h5 class="text-warning"><i class="bi bi-app-indicator"></i>
                                                                {{ $stnk }} </h5>
                                                        @else
                                                            <h5 class="text-danger"><i class="bi bi-app-indicator"></i>
                                                                {{ $stnk }} </h5>
                                                        @endif

                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            <div class="col ">
                                <div class=" menu-5 rounded shadow ">
                                    <a href="/superadmin_servis/kendaraan/{{ $data_data->id }}"
                                        class="text-decoration-none ">
                                        <div class="d-flex justify-content-between px-3 ">
                                            <div class="body-icon-5 text-center">
                                                <img src="{{ asset('assets/images/icon/servis.png') }}"
                                                    class="img-icon p-2 rounded" alt="">
                                            </div>
                                            <div class="">
                                                <h5 class="text-oren">Servis</h5>
                                                <h5 class="text-danger"></h5>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="row">
            <div class="col-sm-12">

                <div class="card">

                    <div>
                        <div class="mx-2 ">
                            <div class=" ">
                                <div class="m-0">
                                    <p class="fs-5 text-primary m-0"><i class="bi bi-arrow-left-right"></i> Stok Barang
                                    </p>
                                    <hr class="m-0 text-primary w-25 shadow">
                                </div>
                                <div class="card-header mb-0  ">
                                    @if (session()->has('success'))
                                        <div class=" mb-0 alert alert-success alert-dismissible fade show" role="alert">
                                            <strong><i class="bi bi-check-square"></i> </strong>
                                            {{ session('success') }}
                                            <button type="button" class="btn-close" data-bs-dismiss="alert"
                                                aria-label="Close"></button>
                                        </div>
                                    @endif
                                    @if (session()->has('delete'))
                                        <div class="mb-0 alert alert-danger alert-dismissible fade show" role="alert">
                                            <strong>Sukses, </strong> {{ session('delete') }}
                                            <button type="button" class="btn-close" data-bs-dismiss="alert"
                                                aria-label="Close"></button>
                                        </div>
                                    @endif
                                </div>

                                <div class="row">
                                    <div class="col-12">
                                        <label for="" class="fw-bold">Filter Tanggal</label>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <input type="date" name="tglawal" class="pencarian "
                                                placeholder="Tanggal Awal">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <input type="date" name="tglakhir" class="pencarian"
                                                placeholder="Tanggal Akhir">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <button class="tombol_search" onclick="filter()"><i class="bi bi-funnel"></i>
                                            Filter</button>
                                        <button class="tombol_reset" onclick="reset()"><i class="bi bi-stars"></i>
                                            Reset</button>
                                        <button class="tombol_print" onclick="print()">
                                            <i class="bi bi-printer"></i>
                                            Print</button>
                                        <button class="tombol_pdf" onclick="pdf()"><i class="bi bi-filetype-pdf"></i>
                                            PDF</button>
                                    </div>
                                </div>


                                <div class="table-responsive">
                                    <table id="table-1"
                                        class="display nowrap table table-sm table-bordered  table-striped table-hover text-nowrap "
                                        style="width:100%">
                                        <thead>
                                            <th class="border-bottom-0" width="1%">No</th>
                                            <th class="border-bottom-0">Kode Kendaraan</th>
                                            <th class="border-bottom-0">Nama Kendaraan</th>
                                            <th class="border-bottom-0">Merek</th>
                                            <th class="border-bottom-0">Jumlah Masuk</th>
                                            <th class="border-bottom-0">Jumlah Keluar</th>
                                            <th class="border-bottom-0">Total Stok</th>
                                            <th class="border-bottom-0">Opsi</th>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>





                            </div>
                        </div>
                    </div>


                </div>
            </div>


        </div>


    </div>
@endsection



<script>
    $(document).ready(function() {
        // BOOTSTRAP DATEPICKER
        $('.datepicker-date').bootstrapdatepicker({
            format: "yyyy-mm-dd",
            viewMode: "date",
            autoclose: true,
        })
    })
</script>


@section('scripts')
    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $(document).ready(function() {
            getData();
        });

        function getData() {
            //datatables
            table = $('#table-1').DataTable({
                language: {
                    entries: ' Data',
                    search: 'Pencarian',
                    // url: 'https://cdn.datatables.net/plug-ins/1.11.5/i18n/de-DE.json'
                },

                "processing": true,
                "serverSide": true,
                "info": true,
                "order": [],
                "scrollX": true,
                "stateSave": true,
                "lengthMenu": [
                    [5, 10, 25, 50, 100, 200],
                    [5, 10, 25, 50, 100, 200]
                ],
                "pageLength": 10,

                lengthChange: true,

                "ajax": {
                    "url": "/superadmin_kendaraan/kendaraan/get_data/{{ $data_data->id }}",
                    "data": function(d) {
                        d.tglawal = $('input[name="tglawal"]').val();
                        d.tglakhir = $('input[name="tglakhir"]').val();
                    }
                },

                "columns": [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        searchable: false
                    },
                    {
                        data: 'kode',
                        // name: 'kode_barang',
                    },
                    {
                        data: 'nama_kendaraan',
                        // name: 'nama_barang',
                    },

                    {
                        data: 'merek',
                        // name: 'merek',
                    },
                    {
                        data: 'jmlmasuk',
                        // name: 'kode_barang',
                        orderable: false,
                    },
                    {
                        data: 'jmlkeluar',
                        // name: 'kode_barang',
                        searchable: false,
                        orderable: false,
                    },
                    {
                        data: 'totalstok',
                        // name: 'kode_barang',
                        searchable: false,
                        orderable: false,
                    },
                    {
                        data: 'opsi',
                        name: 'opsi',
                        searchable: false,
                        orderable: false,
                    },


                ],

                columnDefs: [{
                        targets: [0, 1, 2, 3, 4, 5, 6, 7],
                        render: function(data, type, row, meta) {
                            if (type === 'display') {
                                data = '<div style="font-size: 14px" >' + data + '</div>';
                            }
                            return data;
                        }
                    },
                    // {
                    //     targets: 1,
                    //     render: function(data, type, row, meta) {
                    //         if (type === 'display') {
                    //             data =
                    //                 '<a style="font-size: 14px" class="fw-bold text-decoration-none" href="/superadmin_kendaraan/show/' +
                    //                 encodeURIComponent(data) + '/{{ $data_data->id }}">' + data + '</a>';
                    //         }

                    //         return data;
                    //     }
                    // },


                ],



            });
        }

        function filter() {
            var tglawal = $('input[name="tglawal"]').val();
            var tglakhir = $('input[name="tglakhir"]').val();
            if (tglawal != '' && tglakhir != '') {
                table.ajax.reload(null, false);
            } else {
                validasi("Isi dulu Form Filter Tanggal!", 'warning');
            }

        }

        function reset() {
            $('input[name="tglawal"]').val('');
            $('input[name="tglakhir"]').val('');
            table.ajax.reload(null, false);
        }

        function print() {
            var tglawal = $('input[name="tglawal"]').val();
            var tglakhir = $('input[name="tglakhir"]').val();
            if (tglawal != '' && tglakhir != '') {
                window.open(
                    "/superadmin_kendaraan/print_all/{{ $data_data->id }}/" + tglawal + "&" + tglakhir,
                    '_blank'
                );
            } else {
                alert("Pilih Filter Tanggal !");
            }
        }




        function validasi(judul, status) {
            swal({
                title: judul,
                type: status,
                confirmButtonText: "Iya."
            });
        }
    </script>
@endsection
