@extends('layouts.index')

@section('main')
    <div class="">
        <div class="pc-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="">

                                <div class="page-header-title">
                                    {{-- <h5 class="m-b-10">Tabler Icons</h5> --}}
                                </div>
                                <ul class="breadcrumb">
                                    <li class="breadcrumb-item"><a class="text-decoration-none" href="#">Home</a>
                                    </li>
                                    <li class="breadcrumb-item"><a class="text-decoration-none" href="#">{{ $data_data->proyek->divisi->perusahaan->kode_perusahaan }}</a></li>
                                    <li class="breadcrumb-item" aria-current="page"><a href="/superadmin_proyek/{{ $data_data->proyek->divisi->perusahaan->kode_perusahaan }}/divisi/{{ $data_data->proyek->id }}">{{ $data_data->proyek->divisi->nama_divisi }}</a>
                                    </li>
                                    <li class="breadcrumb-item" aria-current="page"><a href="/superadmin_sub_divisi/{{ $data_data->proyek->divisi->perusahaan->kode_perusahaan }}/{{ $data_data->proyek->divisi->id }}/proyek/{{ $data_data->proyek->id }}">{{ $data_data->proyek->nama_proyek }}</a></li>
                                    <li class="breadcrumb-item" aria-current="page"><a href="/superadmin_consumable/consumable/{{ $data_data->id }}" class="">{{ $data_data->nama_sub_divisi }}</a></li>
                                </ul>

                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->

            <!--[ Main Content ] start-->
            <div class="row">
                <div class="col-sm-12">
                    <div class="card">
                        <div class="d-flex justify-content-between mx-2 py-2">
                            <div class="">
                                <div class="d-flex text-center">
                                    {{-- <img src="{{ asset('images/logo-1.png') }}" width="45" height="45" alt=""> --}}
                                    <p class="fs-6 teks text-hijau fw-bold"><i class="bi bi-dropbox"></i> Kode Barang
                                        {{ $barang->kode_barang }}</p>
                                </div>

                            </div>
                            <div class="d-flex align-items-center">
                                <a type="button" onclick="goBack()" class="tombol_kembali text-light"><i
                                        class="bi bi-backspace"></i> Kembali</a>
                            </div>
                        </div>

                        <div class="p-3">
                            <div class="row row-cols-1 row-cols-md-2 g-4">
                                <div class="col">
                                  <div class="card">
                                    <div class="row p-2">
                                        <div class="col">
                                            <p class="m-0">Kode Barang</p>
                                            <p class="m-0">Nama Barang</p>
                                            <p class="m-0">Merek</p>
                                            <p class="m-0">Kategori</p>
                                            <p class="m-0">Sub Divisi</p>
                                            <p class="m-0">Proyek</p>
                                            <p class="m-0">Divisi</p>
                                            <p class="m-0">Perusahaan</p>
                                        </div>
                                        <div class="col">
                                            <p class="m-0">: {{ $barang->kode_barang }}</p>
                                            <p class="m-0">: {{ $barang->nama_barang }}</p>
                                            <p class="m-0">: {{ $barang->merek }}</p>
                                            <p class="m-0">: {{ $barang->kategori->nama_kategori }}</p>
                                            <p class="m-0">: {{ $barang->sub_divisi->nama_sub_divisi }}</p>
    
                                            <p class="m-0">: {{ $barang->proyek->nama_proyek }}</p>
                                            <p class="m-0">: {{ $barang->divisi->nama_divisi }}</p>
                                            <p class="m-0">: {{ $barang->perusahaan->nama_perusahaan }}</p>
                                            
                                        </div>
    
                                    </div>


                                  </div>
                                </div>
                                <div class="col">
                                  <div class="card">
                                    <div class="card-body">
                                      <h5 class="card-title">STOK</h5>
                                      <div class="row">
                                        <div class="d-flex justify-content-between">
                                            <div class="border border-primary rounded " style="width: 150px" >
                                                <div class="row px-2">
                                                    <div class="col-4"><i class="bi bi-arrow-down-square fs-1 text-primary"></i>
                                                    </div>
                                                    <div class="col-8 text-center align-self-center">
                                                        <p class="m-0 text-primary" style="font-size: 12px">Barang Masuk</p>
                                                        <p class="m-0 text-primary fw-b0old fs-5">{{ $masuk }}</p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="border border-danger rounded mx-2 " style="width: 150px" >
                                                <div class="row px-2">
                                                    <div class="col-4"><i class="bi bi-arrow-up-square text-danger fs-1"></i>
                                                    </div>
                                                    <div class="col-8 text-center align-self-center">
                                                        <p class="m-0 text-danger" style="font-size: 12px">Barang Keluar</p>
                                                        <p class="m-0 text-danger fw-b0old fs-5">{{ $keluar }}</p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="border border-success rounded " style="width: 150px" >
                                                <div class="row px-2">
                                                    <div class="col-4"><i class="bi bi-inboxes fs-1 text-success"></i>
                                                    </div>
                                                    <div class="col-8 text-center align-self-center">
                                                        <p class="m-0 text-success" style="font-size: 12px">Barang Stok</p>
                                                        <p class="m-0 text-success fw-b0old fs-5">{{ $masuk - $keluar }}</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                               
                              
                              </div>

                        </div>

                        <div class="d-flex justify-content-between mx-2 ">
                            <div class="">
                                <div class="d-flex text-center">
                                    {{-- <img src="{{ asset('images/logo-1.png') }}" width="45" height="45" alt=""> --}}
                                    <p class="fs-6 teks text-hijau fw-bold"><i class="bi bi-dropbox"></i> Daftar Barang Masuk</p>
                                </div>

                            </div>
                            <div class="d-flex align-items-center">
                                <a href="/superadmin_consumable/add_barang_masuk/{{ $barang->kode_barang }}" class="tombol_tambah"><i class="bi bi-folder-plus"></i> Tambah</a>
                            </div>
                        </div>

                        <div>
                            <div class="mx-2  pb-1">
                                <div class="shadow ">

                                    <div class="table-responsive p-1">
                                        <table class="table table-sm table-striped table-hover text-nowrap">
                                            <thead class="thead-light">
                                                <tr class="tabel table-active">
                                                    <th class="">No</th>
                                                    <th scope="col" class="">Tanggal</th>
                                                    <th scope="col" class="text-center">Jumlah</th>
                                                    <th scope="col" class="text-center">Satuan</th>
                                                    <th scope="col" class="">Penerima</th>
                                                    <th scope="col" class="">Suplayer/Toko</th>
                                                    <th scope="col" class="text-center">Gambar</th>
                                                    <th scope="col" class="text-center">Keterangan</th>
                                                </tr>
                                            </thead>

                                            <tbody>
                                                @php
                                                    $no = 1;
                                                @endphp
                                                @if (count($in_barang))
                                                    @foreach ($in_barang as $item)
                                                        <tr class="tabel tabel-1  ">
                                                            <th scope="row">{{ $no++ }}</th>
                                                            <td >{{ date('d-m-Y', strtotime($item->tanggal)) }}</td>
                                                            <td class="text-center">{{ $item->jumlah }}</td>
                                                            <td class="text-center">{{ $item->satuan }}</td>
                                                            <td>{{ $item->penerima }}</td>
                                                            <td class="">{{ $item->suplayer }}</td>
                                                            <td class="text-center"><a target="_blank" rel="noopener noreferrer" href="/superadmin_consumable/gambar/{{ $item->id }}"><i class="bi bi-card-image"></i></a></td>
                                                            <td class="text-center">{{ $item->keterangan }}</td>
                                                           
                                                        </tr>
                                                    @endforeach
                                                @else
                                                    <div class="table-responsive">
                                                        <tr class=" text-center text-danger fw-bold">
                                                            <td colspan="8"><i class="bi bi-info-circle"></i> Belum Ada Barang Masuk !!!</td>
                                                        </tr>
                                                    </div>
                                                @endif
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex bd-highlight mx-3 mb-3 ">
                                <div class=" ">
                                    <p class="teks-halaman mb-0">Halaman : {{ $in_barang->currentPage() }} </p>
                                    <p class="teks-halaman mb-0">Jumlah Data : {{ $in_barang->total() }} </p>
    
                                </div>
                                <div class="ms-auto p-2">
                                    {{ $in_barang->links() }}
                                </div>
                            </div>
                        </div>



                        <div class="d-flex justify-content-between mx-2 ">
                            <div class="">
                                <div class="d-flex text-center">
                                    {{-- <img src="{{ asset('images/logo-1.png') }}" width="45" height="45" alt=""> --}}
                                    <p class="fs-6 teks text-hijau fw-bold"><i class="bi bi-dropbox"></i> Daftar Barang Keluar</p>
                                </div>

                            </div>
                            <div class="d-flex align-items-center">
                                <a href="/superadmin_consumable/add_barang_keluar/{{ $barang->kode_barang }}" class="tombol_tambah"><i class="bi bi-folder-plus"></i> Tambah</a>
                            </div>
                        </div>

                        <div>
                            <div class="mx-2  pb-1">
                                <div class="shadow ">

                                    <div class="table-responsive p-1">
                                        <table class="table table-sm table-striped table-hover text-nowrap">
                                            <thead class="thead-light">
                                                <tr class="tabel table-active">
                                                    <th class="">No</th>
                                                    <th scope="col" class="">Tanggal</th>
                                                    <th scope="col" class="text-center">Jumlah</th>
                                                    <th scope="col" class="text-center">Satuan</th>
                                                    <th scope="col" class="">Nama</th>
                                                    <th scope="col" class="">Divisi</th>
                                                    <th scope="col" class="text-center">Lokasi</th>
                                                    <th scope="col" class="text-center">Status</th>
                                                    <th scope="col" class="text-center">Keterangan</th>
                                                    
                                                </tr>
                                            </thead>

                                            <tbody>
                                                @php
                                                    $no = 1;
                                                @endphp
                                                @if (count($out_barang))
                                                    @foreach ($out_barang as $item)
                                                        <tr class="tabel tabel-1  ">
                                                            <th scope="row">{{ $no++ }}</th>
                                                            <td>{{ date('d-m-Y', strtotime($item->tanggal)) }}</td>
                                                            <td class="text-center">{{ $item->jumlah }}</td>
                                                            <td class="text-center">{{ $item->satuan }}</td>
                                                            <td class="">{{ $item->nama }}</td>
                                                            <td>{{ $item->n_divisi }}</td>
                                                            <td class="text-center">{{ $item->lokasi }}</td>
                                                            <td class="text-center" >{{ $item->status }}</td>
                                                            <td class="text-center" >{{ $item->keterangan }}</td>
                                                        </tr>
                                                    @endforeach
                                                @else
                                                    <div class="table-responsive">
                                                        <tr class=" text-center text-danger fw-bold">
                                                            <td colspan="9"><i class="bi bi-info-circle"></i> Belum Ada Barang Keluar !!!</td>
                                                        </tr>
                                                    </div>
                                                @endif

                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex bd-highlight mx-3 mb-3 ">
                                <div class=" ">
                                    <p class="teks-halaman mb-0">Halaman : {{ $out_barang->currentPage() }} </p>
                                    <p class="teks-halaman mb-0">Jumlah Data : {{ $out_barang->total() }} </p>
    
                                </div>
                                <div class="ms-auto p-2">
                                    {{ $out_barang->links() }}
                                </div>
                            </div>
                        </div>
                        

                    </div>


                </div>
            </div>


        </div>


        <!--[ Main Content ] end-->

    </div>



    </div>

    </div>




    <script>
        $(document).ready(function() {
            $('#dataTable').DataTable(); // ID From dataTable 
            $('#dataTableHover').DataTable(); // ID From dataTable with Hover
        });
    </script>
@endsection
