<!DOCTYPE html>
<html lang="en">

<?php

use Carbon\Carbon;
?>

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="{{$web->web_deskripsi}}">
    <meta name="author" content="{{$web->web_nama}}">
    <meta name="keywords" content="">
    <meta name="csrf-token" content="{{ csrf_token() }}" />

    <!-- FAVICON -->
    @if($web->web_logo == '' || $web->web_logo == 'default.png')
    <link rel="shortcut icon" type="image/x-icon" href="{{url('/assets/default/web/default.png')}}" />
    @else
    <link rel="shortcut icon" type="image/x-icon" href="{{asset('storage/web/' . $web->web_logo)}}" />
    @endif

    <title>BMS-ASET-BRG-KELUAR_{{Carbon::parse($tglawal)->translatedFormat('d-m-Y')}}/{{Carbon::parse($tglakhir)->translatedFormat('d-m-Y')}}</title>

    <style>
        * {
            font-family: Arial, Helvetica, sans-serif;
        }
        #img {
            width: 200px;
            height: 200px;
        }

        #table1 {
            border-collapse: collapse;
            width: 100%;
            margin-top: 32px;
        }

        #table1 td,
        #table1 th {
            border: 1px solid #2c3e50;
            padding: 8px;
        }

        #table1 th {
            padding-top: 12px;
            padding-bottom: 12px;
            color: black;
            font-size: 12px;
        }

        #table1 td {
            font-size: 11px;
        }

        .font-medium {
            font-weight: 500;
        }

        .font-bold {
            font-weight: 600;
        }

        .d-2 {
            display: flex;
            align-items: flex-start;
            margin-top: 32px;
        }
    </style>

</head>

<body onload="window.print()">

    <center>
        @if($web->web_logo == '' || $web->web_logo == 'default.png')
        <img src="{{url('/assets/images/bmsblack.png')}}" width="150px" alt="">
        @else
        <img src="{{asset('storage/web/' . $web->web_logo)}}" width="80px" alt="">
        @endif
    </center>

    <center>
        <h3 class="font-medium">PRODUKSI</h3>
        <h3 class="font-medium">Laporan Barang Keluar</h3>
        @if($tglawal == '')
        <h4 class="font-medium">Semua Tanggal</h4>
        @else
        {{-- <h4 class="font-medium">{{Carbon::parse($tglawal)->translatedFormat('d F Y')}} - {{Carbon::parse($tglakhir)->translatedFormat('d F Y')}}</h4> --}}
        @endif
        Tanggal {{Carbon::parse($tglawal)->translatedFormat('d-m-Y')}} s/d {{Carbon::parse($tglakhir)->translatedFormat('d-m-Y')}}
    </center>


    <table border="1" id="table1">
        <thead>
            <tr>
                <th align="center" width="1%">NO</th>
                <th>KODE BARANG</th>
                <th>NAMA BARANG</th>
                <th>MEREK</th>
                <th>JUMLAH</th>
                <th>SATUAN</th>
                <th>PENGGUNA</th>
                <th>DIVISI</th>
                <th>LOKASI</th>
                <th>TANGGAL</th>
            </tr>
        </thead>
        <tbody>
            @php $no=1; @endphp
            @foreach($data as $d)
            <tr>
                <td align="center">{{$no++}}</td>
                <td>{{$d->gs_barang->kode_barang}}</td>
                <td>{{$d->gs_barang->nama_barang}}</td>
                <td>{{$d->gs_barang->merek}}</td>
                <td align="center">{{$d->jumlah}}</td>
                <td align="center">{{$d->satuan}}</td>
                <td>{{$d->nama}}</td>
                <td>{{$d->divisi->nama_divisi}}</td>
                <td>{{$d->lokasi}}</td>
                <td align="center">{{Carbon::parse($d->tanggal)->translatedFormat('d-m-Y')}}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

</body>

</html>