@extends('layouts.index')

@section('main')
    <div class="pc-content">
        <div class="page-header">
            <div class="page-block">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <div class="">

                            <div class="page-header-title">
                                {{-- <h5 class="m-b-10">Tabler Icons</h5> --}}
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a class="text-decoration-none" href="/superadmin_1">Home</a>
                                </li>
                                <li class="breadcrumb-item"><a class="text-decoration-none" href="#">{{ $menu }}</a></li>
                                <li class="breadcrumb-item" aria-current="page">{{ $nama_menu }}</li>
                            </ul>

                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">

                <div class="shadow bg-light col-sm-6 p-3 " style="border-radius: 20px">
                    <div class="d-flex justify-content-between  mt-2">
                        <div class="d-flex text-center">
                            {{-- <img src="{{ asset('images/logo-1.png') }}" width="45" height="45" alt=""> --}}
                            <p class="fs-6 teks fw-bold"><i class="bi bi-building "></i> Tambah Perusahaan</p>
                        </div>

                    </div>
                    {{-- <div class=" ">
            <h5 class="text-success">Total = <span class="fw-bold">Rp.1.000.000.000</span> </h5>
        </div> --}}
                    {{-- <hr class="mt-0 p-1 bg-primary rounded" width="350" ></hr> --}}
                    <form action="/superadmin_master_divisi" method="post" enctype="multipart/form-data">
                        @csrf

                        <div class="">

                            <div class="">
                                <div class="mb-3">
                                    <label for="perusahaan" class=" mb-0 teks"><i class="bi bi-houses"></i>
                                        Perusahaan</label>
                                    <select class="shadow-sm form-select form-select-sm rounded-pill" name="perusahaan_id"
                                        value="{{ old('perusahaan_id') }}">
                                        <option value="">-- Pilih Perusahaan --
                                        </option>
                                        @foreach ($perusahaan as $item)
                                            <option value="{{ $item->id }}">-
                                                {{ $item->nama_perusahaan }}</option>
                                        @endforeach
                                    </select>
                                    @error('perusahaan_id')
                                        <div class="text-danger">
                                            <span class="ps-3 fst-italic"><i class="bi bi-info-circle"></i> Perusahaan
                                                wajib di pilih !</span>
                                        </div>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="kode_divisi" class="form-label teks mb-0"><i class="bi bi-houses"></i> Kode Divisi</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('kode_divisi') is-invalid @enderror "
                                        name="kode_divisi" required autofocus value="{{ old('kode_divisi') }}"  onkeyup="this.value = this.value.toUpperCase()">
                                    @error('kode_divisi')
                                        <div class="text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Divisi sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>


                                <div class="mb-3">
                                    <label for="nama_divisi" class=" mb-0 teks"><i class="bi bi-houses"></i> Nama
                                        Divisi</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('nama_divisi') is-invalid @enderror "
                                        name="nama_divisi" required autofocus value="{{ old('nama_divisi') }}"
                                        aria-label="Sizing example input" aria-describedby="inputGroup-sizing-sm" onkeyup="this.value = this.value.toUpperCase()">
                                    @error('nama_divisi')
                                        <div class="text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Perusahaan sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>
                                {{-- <div class="">
                                <label for="roles" class="form-label mb-0 fw-bold"><i class="bi bi-bar-chart-line"></i> Level User</label>
                                <div class="d-flex justify-content-start">
                                    <div class=" ">
                                        <input type="radio" id="superadmin" value="superadmin" name="roles" >
                                        <label for="superadmin">Superadmin</label>
                                    </div>
                                    <div class="mx-3">
                                        <input type="radio" id="admin" value="admin" name="roles" >
                                        <label for="admin">Admin</label>
                                    </div>
                                    <div class="">
                                        <input type="radio" id="karyawan" value="karyawan" name="roles"
                                            >
                                        <label for="karyawan">Karyawan</label>
                                    </div>
                                </div>
                                @error('roles')
                                <div class="text-danger">
                                    <span class="fst-italic"><i class="bi bi-info-circle"></i> Level user belum dipilih ! </span>
                                </div>
                                @enderror
                            </div> --}}

                            </div>


                        </div>



                        <div class="d-flex justify-content-around mt-4">
                            <button type="submit" class="shadow btn btn-primary btn-sm col-3  rounded-pill mb-5">Simpan</button>
                            <a href="" onclick="goBack()" class="shadow btn btn-danger btn-sm col-3 mb-5 rounded-pill ">Batal</a>

                        </div>

                    </form>

                </div>
            </div>
        </div>





    </div>

    {{-- <script>
        const judul = document.querySelector('#judul')
        const slug = document.querySelector('#slug')

        judul.addEventListener('change', function() {
            fetch('/adminberita/checkSlug?judul=' + judul.value);
            .then(response => response.json())
                .then(data => slug.value = data.slug)
        })
    </script> --}}
@endsection
