@extends('layouts.index')

@section('main')
    <div class="">
        <div class="pc-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="">

                                <div class="page-header-title">
                                    {{-- <h5 class="m-b-10">Tabler Icons</h5> --}}
                                </div>
                                <ul class="breadcrumb">
                                    <li class="breadcrumb-item"><a class="text-decoration-none" href="/admin">Home</a>
                                    </li>
                                    <li class="breadcrumb-item"><a class="text-decoration-none" href="#">Profil</a>
                                    </li>
                                </ul>

                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->

            <!--[ Main Content ] start-->
            <div class="row">
                <div class="col-sm-12">
                    <div class="card">
                        <div class="d-flex justify-content-between mx-2 py-2">
                            <div class="">
                                <form class="row" action="#">
                                    <div>
                                        <p class="fs-6 text-hijau fw-bold"><i class="bi bi-person-circle"></i> Profil Akun
                                        </p>
                                    </div>
                                </form>

                            </div>
                            <div class="d-flex align-items-center">
                                {{-- <a href="/superadmin_master_akun/create" class="tombol_add"><i class="bi bi-folder-plus"></i> Add</a> --}}
                            </div>
                        </div>

                        <div>
                            <div class="mx-2 pb-5">
                                <div class="">
                                    <div class="row px-3">
                                        <div class="col shadow me-2 ">

                                            <div class="mb-3">
                                                <label for="kategori" class="form-label teks mb-0"><i
                                                        class="bi bi-person-circle"></i> Perusahaan</label>
                                                <input type="text" placeholder=""
                                                    class="form-control form-control-sm rounded-pill @error('nama_kategori') is-invalid @enderror "
                                                    name="nama_kategori" required autofocus
                                                    value="{{ $data->perusahaan->nama_perusahaan }}"
                                                    onkeyup="this.value = this.value.toUpperCase()" disabled>
                                                @error('nama_kategori')
                                                    <div class="text-danger">
                                                        <span class="fst-italic"><i class="bi bi-info-circle"></i> Kategori
                                                            sudah ada
                                                            !</span>
                                                    </div>
                                                @enderror
                                            </div>
                                            <div class="mb-3">
                                                <label for="kategori" class="form-label teks mb-0"><i
                                                        class="bi bi-person-circle"></i> Divisi</label>
                                                <input type="text" placeholder=""
                                                    class="form-control form-control-sm rounded-pill @error('nama_kategori') is-invalid @enderror "
                                                    name="nama_kategori" required autofocus
                                                    value="{{ $data->divisi->nama_divisi }}"
                                                    onkeyup="this.value = this.value.toUpperCase()" disabled>
                                                @error('nama_kategori')
                                                    <div class="text-danger">
                                                        <span class="fst-italic"><i class="bi bi-info-circle"></i> Kategori
                                                            sudah ada
                                                            !</span>
                                                    </div>
                                                @enderror
                                            </div>
                                            <div class="mb-3">
                                                <label for="kategori" class="form-label teks mb-0"><i
                                                        class="bi bi-person-circle"></i> Proyek Area</label>
                                                <input type="text" placeholder=""
                                                    class="form-control form-control-sm rounded-pill @error('nama_kategori') is-invalid @enderror "
                                                    name="nama_kategori" required autofocus
                                                    value="{{ $data->proyek->nama_proyek }}"
                                                    onkeyup="this.value = this.value.toUpperCase()" disabled>
                                                @error('nama_kategori')
                                                    <div class="text-danger">
                                                        <span class="fst-italic"><i class="bi bi-info-circle"></i> Kategori
                                                            sudah ada
                                                            !</span>
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="col shadow">
                                            <form action="/admin_profil/{{ auth()->user()->id }}" method="post">
                                                @method('put')
                                                @csrf
                                                <div class="mb-3">
                                                    <label for="kategori" class="form-label teks mb-0"><i
                                                            class="bi bi-person-circle"></i> Nama Akun</label>
                                                    <input type="text" placeholder=""
                                                        class="form-control form-control-sm rounded-pill @error('name') is-invalid @enderror "
                                                        name="name" required autofocus
                                                        value="{{ old('name', auth()->user()->name) }}"
                                                        >
                                                    @error('name')
                                                        <div class="text-danger">
                                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Nama
                                                                sudah ada
                                                                !</span>
                                                        </div>
                                                    @enderror
                                                </div>
                                                <div class="mb-3">
                                                    <label for="kategori" class="form-label teks mb-0"><i
                                                            class="bi bi-person-circle"></i> Username</label>
                                                    <input type="text" placeholder=""
                                                        class="form-control form-control-sm rounded-pill @error('username') is-invalid @enderror "
                                                        name="username" required autofocus
                                                        value="{{ old('username', auth()->user()->username) }}"
                                                        >
                                                    @error('username')
                                                        <div class="text-danger">
                                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Username
                                                                sudah ada
                                                                !</span>
                                                        </div>
                                                    @enderror
                                                </div>
                                                <div class="mb-3">
                                                    <label for="kategori" class="form-label teks mb-0"><i
                                                            class="bi bi-person-circle"></i> Password Baru</label>
                                                    <input type="text" placeholder=""
                                                        class="form-control form-control-sm rounded-pill @error('password') is-invalid @enderror "
                                                        name="password" required autofocus value="{{ old('password') }}"
                                                        >
                                                    @error('password')
                                                        <div class="text-danger">
                                                            <span class="fst-italic"><i class="bi bi-info-circle"></i>
                                                                Password wajib dilengkapi
                                                                !</span>
                                                        </div>
                                                    @enderror
                                                </div>

                                                <div class="mt-4">
                                                    <button type="submit"
                                                        class="shadow btn btn-primary btn-sm col-3  rounded-pill mb-5">Simpan</button>

                                                </div>
                                            </form>

                                        </div>

                                    </div>


                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <!--[ Main Content ] end-->
        </div>
    </div>

    </div>




    <script>
        $(document).ready(function() {
            $('#dataTable').DataTable(); // ID From dataTable 
            $('#dataTableHover').DataTable(); // ID From dataTable with Hover
        });
    </script>
@endsection
