@extends('layouts.index')

@section('main')
    <div class="pc-content">
        <div class="page-header">
            <div class="page-block">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <div class="">

                            <div class="page-header-title">
                                {{-- <h5 class="m-b-10">Tabler Icons</h5> --}}
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a class="text-decoration-none" href="/superadmin_1">Home</a>
                                </li>
                                <li class="breadcrumb-item"><a class="text-decoration-none"
                                        href="#">{{ $menu }}</a></li>
                                <li class="breadcrumb-item" aria-current="page">{{ $nama_menu }}</li>
                            </ul>

                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">

                <div class="shadow bg-light col-sm-12 p-3 " style="border-radius: 20px">
                    <div class="d-flex justify-content-between  mt-2">
                        <div class="d-flex text-center">
                            {{-- <img src="{{ asset('images/logo-1.png') }}" width="45" height="45" alt=""> --}}
                            <p class="fs-6 teks fw-bold"><i class="bi bi-person-plus-fill"></i> Tambah Akun</p>
                        </div>

                    </div>
                    {{-- <div class=" ">
            <h5 class="text-success">Total = <span class="fw-bold">Rp.1.000.000.000</span> </h5>
        </div> --}}
                    {{-- <hr class="mt-0 p-1 bg-primary rounded" width="350" ></hr> --}}
                    <form action="/superadmin_master_akun" method="post" enctype="multipart/form-data">
                        @csrf

                        <div class="row">

                            <div class="col-6">

                                <div class="mb-3">
                                    <label for="name" class="form-label teks mb-0"><i class="bi bi-person-circle"></i> Name</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('name') is-invalid @enderror "
                                        name="name" required autofocus value="{{ old('name') }}"
                                       >
                                    @error('name')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Name sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="username" class="form-label teks mb-0"><i class="bi bi-person-circle"></i> Username</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('username') is-invalid @enderror "
                                        name="username" required autofocus value="{{ old('username') }}"
                                     >
                                    @error('username')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Username sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>
                              

                            </div>


                            <div class="col-6">
                                <div class="mb-3">
                                    <label for="password" class="form-label teks mb-0"><i class="bi bi-key"></i> Password</label>
                                    <input type="text" placeholder=""
                                        class="form-control form-control-sm rounded-pill @error('password') is-invalid @enderror "
                                        name="password" required autofocus value="{{ old('password') }}"
                                      >
                                    @error('password')
                                        <div class="teks-notif text-danger">
                                            <span class="fst-italic"><i class="bi bi-info-circle"></i> Password sudah ada
                                                !</span>
                                        </div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="level" class=" mb-0 teks"><i class="bi bi-reception-4"></i>
                                        Level</label>
                                    <select class="shadow-sm form-select form-select-sm rounded-pill" name="level"
                                         value="{{ old('level') }}">
                                        <option selected disabled value="">-- Pilih Level -- </option>
                                        <option  value="superadmin_master">- Superadmin Master</option>
                                        <option  value="perusahaan">- Perusahaan</option>
                                        <option  value="divisi">- Divisi</option>
                                        <option  value="admin">- Admin Area</option>
                                    </select>
                                    @error('level')
                                        <div class="teks-notif text-danger">
                                            <span class="ps-3 fst-italic"><i class="bi bi-info-circle"></i> Kategori
                                                wajib di pilih !</span>
                                        </div>
                                    @enderror
                                </div>
                               
                            </div>
                        </div>




                        <div class="d-flex justify-content-around mt-4">
                            <button type="submit"
                                class="shadow btn btn-primary btn-sm col-3  rounded-pill mb-5">Simpan</button>
                            <a onclick="goBack()"
                                class="shadow btn btn-danger btn-sm col-3 mb-5 rounded-pill ">Batal</a>

                        </div>

                    </form>

                </div>
            </div>
        </div>

    </div>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script>
        $(function() {
            $('#perusahaan').on('change', function() {
                let id_perusahaan = $('#perusahaan').val();

                console.log(id_perusahaan);
                $.ajax({
                    type: 'get',
                    url: "{{ route('getdivisi') }}",
                    data: {
                        id_perusahaan: id_perusahaan
                    },
                    cache: false,

                    success: function(msg) {
                        $('#divisi').html(msg);
                    },
                    error: function(data) {
                        console.log('error: ', data);

                    }
                })
            })

            $('#divisi').on('change', function() {
                let id_divisi = $('#divisi').val();

                console.log(id_divisi);
                $.ajax({
                    type: 'get',
                    url: "{{ route('getsubdivisi') }}",
                    data: {
                        id_divisi: id_divisi
                    },
                    cache: false,

                    success: function(msg) {
                        $('#subdivisi').html(msg);
                    },
                    error: function(data) {
                        console.log('error: ', data);

                    }
                })
            })
        })
    </script>
@endsection
