@extends('layouts.index')

@section('main')

    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title text-hijau" id="exampleModalLabel"><i class="bi bi-ui-checks-grid"></i> Tambah
                        Barang</h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="#">
                        <div class="mb-3">
                            {{-- <label for="recipient-name" class="col-form-label">Masukkan Kode Barang</label> --}}
                            <input type="text" name="cari_barang"
                                placeholder="Masukkan Kode Barang / Nama Barang/ Merek Barang" class="form-control"
                                onkeyup="this.value = this.value.toUpperCase()">
                        </div>

                </div>
                <div class="modal-footer">
                    <button type="submit" class="tombol_add">Cari Barang</button>
                </div>
                </form>

            </div>
        </div>
    </div>


    <div class="pc-content">
        <div class="page-header">
            <div class="page-block">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <div class="">

                            <div class="page-header-title">
                                {{-- <h5 class="m-b-10">Tabler Icons</h5> --}}
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a class="text-decoration-none" href="/admin">Home</a>
                                </li>
                                <li class="breadcrumb-item"><a class="text-decoration-none" href="/admin_menu">{{ $data_data->proyek->divisi->nama_divisi }}</a></li>
                                <li class="breadcrumb-item "  aria-current="page"><a  class="text-decoration-none" href="/inventaris/inventaris/{{ $data_data->id }}" class="">{{ $data_data->nama_sub_divisi }}</a></li>
                                <li class="breadcrumb-item "  aria-current="page"><a  class="text-decoration-none" type="button" onclick="goBack()">KEMBALI</a></li>
                            </ul>

                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">

                <div class="shadow bg-light col-sm-12 p-3 " style="border-radius: 20px">
                    <div class="d-flex justify-content-between  mt-2">
                        <div class="d-flex text-center">
                            {{-- <img src="{{ asset('images/logo-1.png') }}" width="45" height="45" alt=""> --}}
                            <p class="fs-6 teks fw-bold"><i class="bi bi-dropbox"></i> Data Barang</p>
                        </div>

                        <div class="row">
                           
                                <div class="col cont">
                                    <input type="text" id="input" value="{{ request('cari_barang') }}"
                                        class="pencarian" placeholder="Kode Barang/Nama Barang ..">
                                </div>
                               
                        </div>
                        <div class="d-flex text-center">
                            {{-- <img src="{{ asset('images/logo-1.png') }}" width="45" height="45" alt=""> --}}
                            <a href="/consumable/consumable/create/{{ $data_data->id }}" class="me-2 tombol_tambah"><i class="bi bi-folder-plus"></i> Tambah</a>
                            <a type="button" onclick="goBack()" class="tombol_kembali text-light"><i
                                    class="bi bi-backspace"></i> Kembali</a>
                        </div>

                    </div>
                    <div class="mt-5 ">

                        <div>
                            <div id="data_barang"></div>
                        </div>
                       
                    </div>

                </div>

            </div>
        </div>

    </div>

    <script src="http://code.jquery.com/jquery-1.11.1.min.js"></script>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script>
        $(function() {
            $('#perusahaan').on('change', function() {
                let id_perusahaan = $('#perusahaan').val();

                console.log(id_perusahaan);
                $.ajax({
                    type: 'get',
                    url: "{{ route('getdivisi') }}",
                    data: {
                        id_perusahaan: id_perusahaan
                    },
                    cache: false,

                    success: function(msg) {
                        $('#divisi').html(msg);
                    },
                    error: function(data) {
                        console.log('error: ', data);

                    }
                })
            })
        })
    </script>
    <script>
        $(document).ready(function() {
            showData()
            $("#input").keyup(function() {
                var cari = $("#input").val()
                if(cari != ""){
                    $("#data_barang").html('<p class="text-center text-muted">Mencari Barang...</p>')
                    $.ajax({
                        type: "get",
                        url: "/inventaris_pencarian_keluar/{{ $data_data->id }}",
                        data: "barang=" + cari,
                        success: function(data){
                            $("#data_barang").html(data)
                        } 
                    })
                }  
                else {
                    showData()
                }
            })
        })


        function showData() {
            $.get("/inventaris_data_barang_keluar/{{ $data_data->id }}", {},  function(data, status ){
                $("#data_barang").html(data);
            })
        }

    </script>



    {{-- <script>
$( function() {
  $( "#datepicker" ).datepicker();
  uiLibrary: 'bootstrap4'
} );
</script> --}}

@endsection
