<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pajaks', function (Blueprint $table) {
            $table->id();
            $table->foreignId('perusahaan_id');
            $table->foreignId('divisi_id');
            $table->foreignId('proyek_id');
            $table->foreignId('sub_divisi_id');
            $table->foreignId('kendaraan_id');
            $table->foreignId('kendaraan_out_id');
            $table->string('pembayaran_pajak');
            $table->string('pembayaran_stnk');
            $table->string('kir');
            $table->string('keterangan');
            $table->softDeletes();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pajaks');
    }
};
