<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('perawatan__riwayats', function (Blueprint $table) {
            $table->id();
            $table->foreignId('perusahaan_id');
            $table->foreignId('divisi_id');
            $table->foreignId('proyek_id');
            $table->foreignId('sub_divisi_id');
            $table->foreignId('inventaris_id');
            $table->foreignId('inventaris_out_id');
            $table->foreignId('perawatan_id');
            $table->string('servis');
            $table->string('berikut');
            $table->string('teknisi');
            $table->string('keterangan');
            $table->softDeletes();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('perawatan__riwayats');
    }
};
