<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('kendaraan__ins', function (Blueprint $table) {
            $table->id();
            $table->foreignId('perusahaan_id');
            $table->foreignId('divisi_id');
            $table->foreignId('proyek_id');
            $table->foreignId('sub_divisi_id');
            $table->foreignId('kendaraan_id');
            $table->string('aset');
            $table->string('nopol');
            $table->string('warna');
            $table->string('no_rangka');
            $table->string('no_mesin');
            $table->string('tahun');
            $table->string('plat');
            $table->string('stnk');
            $table->string('jumlah');
            $table->string('satuan');
            $table->string('penerima');
            $table->string('nik');
            $table->string('suplayer');
            $table->string('tanggal');
            $table->string('lokasi');
            $table->string('keterangan');
            $table->string('image');
            $table->softDeletes();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('kendaraan__ins');
    }
};
