<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventaris__outs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('perusahaan_id');
            $table->foreignId('divisi_id');
            $table->foreignId('sub_divisi_id');
            $table->foreignId('proyek_id');
            $table->foreignId('inventaris_id');
            $table->string('aset');
            $table->string('nomor_aset');
            $table->string('nomor_seri');
            $table->string('jumlah');
            $table->string('satuan');
            $table->string('nama');
            $table->string('nik');
            $table->string('n_divisi');
            $table->string('lokasi');
            $table->string('tanggal');
            $table->string('status');
            $table->string('keterangan');
            $table->softDeletes();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inventaris__outs');
    }
};
