<?php

namespace App\Models\Kendaraan;

use App\Models\Superadmin\Divisi;
use App\Models\Superadmin\Perusahaan;
use App\Models\Superadmin\Proyek;
use App\Models\Superadmin\Sub_Divisi;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pajak extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    public function kendaraan()
    {
        return $this->belongsTo(Kendaraan::class);
        // return $this->belongsTo(Gs_Barangs::class, 'gs_barang_id');
    }
    public function kendaraan_in()
    {
        return $this->belongsTo(Kendaraan_In::class);
        // return $this->belongsTo(Gs_Barangs::class, 'gs_barang_id');
    }
    public function kendaraan_out()
    {
        return $this->belongsTo(Kendaraan_Out::class);
        // return $this->belongsTo(Gs_Barangs::class, 'gs_barang_id');
    }
    public function perusahaan()
    {
        return $this->belongsTo(Perusahaan::class);
    }
    public function divisi()
    {
        return $this->belongsTo(Divisi::class);
    }
    public function proyek()
    {
        return $this->belongsTo(Proyek::class);
    }
    public function sub_divisi()
    {
        return $this->belongsTo(Sub_Divisi::class);
    }
}
