<?php

namespace App\Http\Controllers\Superadmin;

use App\Http\Controllers\Controller;
use App\Models\Superadmin\Perusahaan;
use App\Models\Superadmin\Sub_Divisi;
use Illuminate\Http\Request;

class Superadmin_Sub_Divisi_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $data = Sub_Divisi::latest();

        if (request('search')) {
            $data->where('kode_sub_divisi', 'like', '%' . request('search') . '%')->orWhere('nama_sub_divisi', 'like', '%' . request('search') . '%');
        }

        return view('superadmin.sub_divisi.index', [
            'menu' => 'Master Data',
            'nama_menu' => 'Sub Divisi',
            'data' => $data->paginate(),

            $title = 'Hapus Data',
            $text = "Apakah anda yakin ingin menghapus?",
            confirmDelete($title, $text),
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        return view('superadmin.sub_divisi.add', [
            'menu' => 'Master Data',
            'nama_menu' => 'Sub Divisi',
            'perusahaan' => Perusahaan::all(),
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $data = $request->validate([
            // 'divisi_id' => 'required',
            'proyek_id' => 'required',
            'nama_sub_divisi' => 'required',
        ]);
        // dd($data);

        // dd($data);
        Sub_Divisi::create($data);
        return redirect('superadmin_master_sub_divisi')->with('toast_success', 'Sub Divisi telah ditambahakan');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
        return view('superadmin.sub_divisi.edit', [
            'menu' => 'Master Data',
            'nama_menu' => 'Sub_Divisi',
            'perusahaan' => Perusahaan::all(),
            'data' => Sub_Divisi::find($id)
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
        $data = $request->validate([
            // 'divisi_id' => 'required',
            'proyek_id' => 'required',
            'nama_sub_divisi' => 'required',
        ]);

        // dd($data);
        Sub_Divisi::where('id', $id)->update($data);
        return redirect('superadmin_master_sub_divisi')->with('toast_success', 'Sub Divisi telah di Update');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        Sub_Divisi::destroy($id);
        return redirect('superadmin_master_sub_divisi')->with('toast_success', 'Perusahaan Divisi Dihapus');
    }

}
