<?php

namespace App\Http\Controllers\Superadmin\Superadmin_Master;

use App\Http\Controllers\Controller;
use App\Models\Roles;
use App\Models\Superadmin\Perusahaan;
use App\Models\Superadmin\Proyek;
use App\Models\User;
use Illuminate\Http\Request;

class Superadmin_Master_Roles_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $data = User::orderBy('id', 'asc');

        if(request('search')) {
            $data->where('name', 'like', '%'. request('search') . '%' )
                    ->orWhere('username', 'like', '%'. request('search') . '%' ) ;
        }

        return view('superadmin.superadmin_master.roles.index', [
            'menu' => 'Master Data',
            'nama_menu' => 'Roles',
            'data' => $data->paginate(),


            $title = 'Hapus Data',
            $text = "Apakah anda yakin ingin menghapus?",
            confirmDelete($title, $text),
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        return view('superadmin.superadmin_master.roles.add', [
            'menu' => 'Master Data',
            'nama_menu' => 'Roles',
            'user' => User::all(),
            'perusahaan' => Perusahaan::all(),
            'proyek' => Proyek::all()


        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //

        $notif['perusahaan_id'] = [
            'required' => 'Perusahaan wajib dipilih',
        ];
        $data = $request->validate([
            'user_id' => 'required',
            'perusahaan_id' => 'required',
            'divisi_id' => 'required',
            // 'sub_divisi_id' => 'required',
            'proyek_id' => 'required',
        ], $notif);

        Roles::create($data);
        return redirect('superadmin_master_roles')->with('toast_success', 'Perubahaan Roles !');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
        $data = Roles::where('user_id', $id)->first();
        return view('superadmin.superadmin_master.roles.edit', [
            'menu' => 'Master Data',
            'nama_menu' => 'Roles',
            'item' => User::find($id),
            'perusahaan' => Perusahaan::all(),
            'proyek' => Proyek::all(),
            'data' => $data



        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
        $data = $request->validate([
            'user_id' => 'required',
            'perusahaan_id' => 'required',
            'divisi_id' => 'required',
            // 'sub_divisi_id' => 'required',
            'proyek_id' => 'required',
        ]);


        Roles::where('id', $id)->update($data);
        return redirect('superadmin_master_roles')->with('toast_success', 'Perubahaan Roles !');
    
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
