<?php

namespace App\Http\Controllers\Superadmin;

use App\Http\Controllers\Controller;
use App\Models\Superadmin\Divisi;
use App\Models\Superadmin\Perusahaan;
use Illuminate\Http\Request;

class Superadmin_Divisi_Controller extends Controller
{
    public function index()
    {
        //
        $data = Divisi::latest();

        if (request('search')) {
            $data->where('kode_divisi', 'like', '%' . request('search') . '%')->orWhere('nama_divisi', 'like', '%' . request('search') . '%');
        }

        return view('superadmin.divisi.index', [
            'menu' => 'Master Data',
            'nama_menu' => 'Divisi',
            'data' => $data->paginate(),

            
            $title = 'Hapus Data',
            $text = "Apakah anda yakin ingin menghapus?",
            confirmDelete($title, $text),
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        return view('superadmin.divisi.add', [
            'menu' => 'Master Data',
            'nama_menu' => 'Divisi',
            'perusahaan' => Perusahaan::all(),
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $data = $request->validate([
            'perusahaan_id' => 'required',
            'kode_divisi' => 'required',
            'nama_divisi' => 'required',
        ]);

        // dd($data);
        Divisi::create($data);
        return redirect('superadmin_master_divisi')->with('toast_success', 'Perusahaan Divisi telah ditambahakan');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
        return view('superadmin.divisi.edit', [
            'menu' => 'Master Data',
            'nama_menu' => 'Divisi',
            'perusahaan' => Perusahaan::all(),
            'item' => Divisi::find($id)
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
        $data = $request->validate([
            'perusahaan_id' => 'required',
            'kode_divisi' => 'required',
            'nama_divisi' => 'required',
        ]);

        // dd($data);

        Divisi::where('id', $id)->update($data);
        return redirect('superadmin_master_divisi')->with('toast_success', 'Perusahaan Divisi telah Di Update');
 
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        Divisi::destroy($id);
        return redirect('superadmin_master_divisi')->with('toast_success', 'Perusahaan Divisi Dihapus');

    }
}
