<?php

namespace App\Http\Controllers\Superadmin\Perusahaan;

use App\Http\Controllers\Controller;
use App\Models\Superadmin\Divisi;
use App\Models\Superadmin\Perusahaan;
use App\Models\Superadmin\Proyek;
use App\Models\Superadmin\Sub_Divisi;
use Illuminate\Http\Request;

class Superadmin_Perusahaan_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $perusahaan = Perusahaan::latest();

        if (request('search')) {
            $perusahaan->where('kode_divisi', 'like', '%' . request('search') . '%')->orWhere('nama_divisi', 'like', '%' . request('search') . '%');
        }

        return view('superadmin.perusahaan.index', [
            // 'menu' => 'Master Data',
            'nama_menu' => 'Perusahaan',
            'perusahaan' => $perusahaan->paginate(),

            
            // $title = 'Hapus Data',
            // $text = "Apakah anda yakin ingin menghapus?",
            // confirmDelete($title, $text),
        ]);

    }

    public function divisi($id)
    {
        //
        $perusahaan = Perusahaan::where('kode_perusahaan', $id)->first();
    
        $divisi = Divisi::where('perusahaan_id', $perusahaan->id)->orderBy('id', 'asc');
        $data_data = sub_divisi::where('proyek_id', $id)->first();

        if (request('search')) {
            $divisi->where('kode_divisi', 'like', '%' . request('search') . '%')->orWhere('nama_divisi', 'like', '%' . request('search') . '%');
        }

        return view('superadmin.perusahaan.divisi', [
            // 'menu' => 'Master Data',
            'nama_menu' => 'DIVISI',
            'perusahaan' => $perusahaan,
            'divisi' => $divisi->paginate(),
            'data_data' => $perusahaan,

            
            // $title = 'Hapus Data',
            // $text = "Apakah anda yakin ingin menghapus?",
            // confirmDelete($title, $text),
        ]);

    }

    public function proyek($data, $id)
    {
        //
        // dd($data, $id);

        $data_data = Proyek::where('divisi_id', $id)->first();
        $data_proyek = Proyek::where('divisi_id', $id)->orderBy('id', 'asc')->get();
        // $data = 
        // dd($divisi);


        return view('superadmin.perusahaan.proyek', [
            // 'menu' => 'Master Data',
            'nama_menu' => 'DIVISI',
            'data_data' => $data_data,
            'proyek' => $data_proyek,

            
            // $title = 'Hapus Data',
            // $text = "Apakah anda yakin ingin menghapus?",
            // confirmDelete($title, $text),
        ]);

    }

    public function sub_divisi($divisi, $proyek, $id)
    {
        //
        // dd( $id);

        $data_data = sub_divisi::where('proyek_id', $id)->first();
        $sub_divisi = Sub_Divisi::where('proyek_id', $id)->orderBy('id', 'asc')->get();
        // $id_divisi = $data_divisi->where('kode_divisi', $divisi)->first();
        // $sub_divisi = Sub_Divisi::where('divisi_id', $id_divisi->id)->orderBy('id', 'asc');
        // dd($divisi);


        // if (request('search')) {
        //     $divisi->where('kode_divisi', 'like', '%' . request('search') . '%')->orWhere('nama_divisi', 'like', '%' . request('search') . '%');
        // }

        return view('superadmin.perusahaan.sub_divisi', [
            // 'menu' => 'Master Data',
            'nama_menu' => 'DIVISI',
            'data_data' => $data_data,
            // 'divisi' => $id_divisi,
            'sub_divisi' => $sub_divisi,
            // 'proyek' => $proyek,
            // 'proyek' => Proyek::all(),

            
            // $title = 'Hapus Data',
            // $text = "Apakah anda yakin ingin menghapus?",
            // confirmDelete($title, $text),
        ]);

    }
    

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
