<?php

namespace App\Http\Controllers\Superadmin\Perusahaan\Kendaraan;

use App\Http\Controllers\Controller;
use App\Models\Kendaraan\Kendaraan;
use App\Models\Kendaraan\Kendaraan_Out;
use App\Models\Kendaraan\Servis;
use App\Models\Kendaraan\Servis_riwayat;
use App\Models\Superadmin\Perusahaan;
use App\Models\Superadmin\Sub_Divisi;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class Superadmin_Kendaraan_Servis_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index($id)
    {
        //
        $data_data = Sub_Divisi::where('id', $id)->first();

        // $data = Consumable_In::where('sub_divisi_id', $id)->orderBy('id', 'asc');

        return view('superadmin.perusahaan.kendaraan.servis.index', [
            'data_data' =>  $data_data,
            'id' => $id,
            // 'data' => $data->paginate(),
     
             $title = 'Hapus Data',
             $text = "Apakah anda yakin ingin menghapus?",
             confirmDelete($title, $text),
             
        ]);
    }

    public function get_data(Request $request, $id) 
    {

        if ($request->ajax()) {
            if ($request->tglawal == '') {
                $data = Servis::where('sub_divisi_id', $id)->orderBy('id', 'DESC')->get();
            } else {
                $data = Servis::where('sub_divisi_id', $id)->whereBetween('created_at', [$request->tglawal, $request->tglakhir])->orderBy('id', 'DESC')->get();
            }
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('tanggal', function ($row) {
                    $tanggal = $row->tanggal == '' ? '-' : Carbon::parse($row->tanggal)->translatedFormat('d-m-Y');

                    $result = '<div  class="fs_tabel ">'.$tanggal.'</div>';

                    return $result;
                })
                ->addColumn('kendaraan', function ($row) {
                    $kendaraan = $row->kendaraan_id == '' ? '-' :  $row->kendaraan->kode_kendaraan;

                    $result = '<a href="/superadmin_servis/show/'.$row->id.'/'.$row->sub_divisi_id.'" class="fs_tabel fw-bold ">'.$kendaraan.'</a>';

                    return $result;
                })
                ->addColumn('nomor', function ($row) {
                    $nomor =  $row->kendaraan_out_id == '' ? '-' :  $row->kendaraan_out->no_aset;

                    $result = '<a href="/superadmin_servis/show/'.$row->id.'/'.$row->sub_divisi_id.'" class="fs_tabel fw-bold ">'.$nomor.'</a>';

                    return $result;
                })
                ->addColumn('nopol', function ($row) {
                    $nopol = $row->kendaraan_out_id == '' ? '-' :  $row->kendaraan_out->kendaraan_in->nopol;

                    $result = '<div  class="fs_tabel ">'.$nopol.'</div>';

                    return $result;
                })
                ->addColumn('nama_kendaraan', function ($row) {
                    $nama_kendaraan = $row->kendaraan_id == '' ? '-' :  $row->kendaraan->nama_kendaraan;

                    $result = '<div  class="fs_tabel ">'.$nama_kendaraan.'</div>';

                    return $result;
                })
                ->addColumn('merek', function ($row) {
                    $merek = $row->kendaraan_id == '' ? '-' :  $row->kendaraan->merek;

                    $result = '<div  class="fs_tabel ">'.$merek.'</div>';

                    return $result;
                })
               
                ->addColumn('warna', function ($row) {
                    $warna = $row->kendaraan_out_id == '' ? '-' :  $row->kendaraan_out->kendaraan_in->warna;

                    $result = '<div  class="fs_tabel ">'.$warna.'</div>';

                    return $result;
                })
                ->addColumn('penerima', function ($row) {
                    $penerima = $row->kendaraan_out_id == '' ? '-' :  $row->kendaraan_out->penerima;

                    $result = '<div  class="fs_tabel ">'.$penerima.'</div>';

                    return $result;
                })
                ->addColumn('nik', function ($row) {
                    $nik = $row->kendaraan_out_id == '' ? '-' :  $row->kendaraan_out->nik;

                    $result = '<div  class="fs_tabel ">'.$nik.'</div>';

                    return $result;
                })
                ->addColumn('divisi', function ($row) {
                    $divisi = $row->kendaraan_out_id == '' ? '-' :  $row->kendaraan_out->n_divisi;

                    $result = '<div  class="fs_tabel ">'.$divisi.'</div>';

                    return $result;
                })
                ->addColumn('pemakai', function ($row) {
                    $pemakai = $row->kendaraan_out_id == '' ? '-' :  $row->kendaraan_out->pemakai;

                    $result = '<div  class="fs_tabel ">'.$pemakai.'</div>';

                    return $result;
                })
                ->addColumn('lokasi', function ($row) {
                    $lokasi = $row->kendaraan_out_id == '' ? '-' :  $row->kendaraan_out->lokasi;

                    $result = '<div  class="fs_tabel ">'.$lokasi.'</div>';

                    return $result;
                })
                ->addColumn('aset', function ($row) {
                    $aset =  $row->kendaraan_out_id == '' ? '-' :  $row->kendaraan_out->kendaraan_in->aset;

                    $result = '<div  class="fs_tabel  ">'.$aset.'</div>';

                    return $result;
                })
                ->addColumn('opsi', function ($row) {
                    $result = '<div  class="bg-transparent d-flex flex-row text-center ">
                    <a href="/superadmin_servis/show/'.$row->id.'/'.$row->sub_divisi_id.'" class="badge-edit text-light me-1"><i class="bi bi-pencil-square"></i></a>
                    <a href="/superadmin_servis/kendaraan/'.$row->id.'" class="badge-delete text-light"  data-confirm-delete="true" ><i class="bi bi-trash"></i></a>
                    </div>';

                    return $result;
                })
                ->rawColumns([
                    'tanggal', 
                    'kendaraan', 
                    'nomor', 
                    'nopol', 
                    'nama_kendaraan', 
                    'merek', 
                    'warna', 
                    'penerima', 
                    'nik', 
                    'divisi', 
                    'pemakai', 
                    'lokasi', 
                    'aset', 
                    'opsi',
                    ])->make(true);
        }
    }

    public function cari_barang($id)
    {

        // dd($id);
        // $data = Gs_Barangs::orderBy('id', 'asc');
        $data_data = Sub_Divisi::where('id', $id)->first();

        $data = Kendaraan_Out::where('sub_divisi_id', $id)->orderBy('no_aset', 'asc');
        // $data = $perusahaan->where('proyek_id', '1')->orderBy('kode_barang', 'asc');
        // $data = Gs_Barangs::orderBy('id', 'asc');

        if (request('cari_barang')) {
            $data->where('no_aset', 'like', '%' . request('cari_barang') . '%')
            ->orWhere('penerima', 'like', '%' . request('cari_barang') . '%');
        }
        return view('superadmin.perusahaan.kendaraan.servis.barang', [
            'data_data' => $data_data,
            'data' => $data->paginate(),
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create($id)
    {
        //
        $kendaraan = Kendaraan::where('id', $id)->first();
        $data_data = Kendaraan_Out::where('kendaraan_id', $kendaraan->id)->first();


        return view('superadmin.perusahaan.kendaraan.servis.add', [
            'data_data' =>  $data_data,
            'perusahaan' => Perusahaan::all(),
          
            // 'kategori' =>  Kategori::all()
            
            ($title = 'Hapus Data'),
            ($text = 'Apakah anda yakin ingin menghapus?'),
            confirmDelete($title, $text),
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, $id)
    {
        //
        $notif['kendaraan_out_id'] = [
            'required' => 'Servis kendaraan sudah ada',
        ];

        $data = $request->validate([
            'perusahaan_id' => 'required',
            'divisi_id' => 'required',
            'sub_divisi_id' => 'required',
            'proyek_id' => 'required',
            'kendaraan_id' => 'required',
            'kendaraan_out_id' => 'required|unique:servis',
        ], $notif);

        // dd($data);
        Servis::create($data);
        return redirect('/superadmin_servis/kendaraan/'.$id)->with('toast_success', 'Data Ditambahkan !');

    }



    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
        // $riwayat = Servis::where('riwayat_id', $id)->orderBy('id', 'desc');

        $riwayat = Servis_riwayat::where('servis_id', $id)->orderBy('id', 'desc');
        $jumlah = Servis_riwayat::where('servis_id', $id)->count();

        return view('superadmin.perusahaan.kendaraan.servis.view', [
            'data_data' => Servis::find($id),
            'riwayat' => $riwayat->paginate(10),
            'jumlah' => $jumlah,

            // 'perusahaan' => Perusahaan::all(),
            // 'riwayat' =>  $riwayat->paginate(10),
  


            ($title = 'Hapus Data'),
            ($text = 'Apakah anda yakin ingin menghapus?'),
            confirmDelete($title, $text),
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        Servis::destroy($id);
        Servis_riwayat::where('servis_id','=', $id)->delete();
        return back()->with('toast_success', 'Data Barang Di Hapus');
    }
}
