<?php

namespace App\Http\Controllers\Superadmin\Perusahaan\Kendaraan;

use App\Http\Controllers\Controller;
use App\Models\Kendaraan\Kendaraan;
use App\Models\Kendaraan\Kendaraan_In;
use App\Models\Kendaraan\Kendaraan_Out;
use App\Models\Kendaraan\Pajak;
use App\Models\Kendaraan\Pajak_Riwayat;
use App\Models\Kendaraan\Servis;
use App\Models\Kendaraan\Servis_riwayat;
use App\Models\Superadmin\Perusahaan;
use App\Models\Superadmin\Sub_Divisi;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class Superadmin_Kendaraan_Out_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index($id)
    {
        //
        $data_data = Sub_Divisi::where('id', $id)->first();

        // $data = Consumable_In::where('sub_divisi_id', $id)->orderBy('id', 'asc');

        return view('superadmin.perusahaan.kendaraan.keluar.index', [
            'data_data' =>  $data_data,
            'id' => $id,
            // 'data' => $data->paginate(),
     
             $title = 'Hapus Data',
             $text = "Apakah anda yakin ingin menghapus?",
             confirmDelete($title, $text),
             
        ]);
    }

    public function get_data(Request $request, $id) 
    {

        if ($request->ajax()) {
            if ($request->tglawal == '') {
                $data = Kendaraan_Out::where('sub_divisi_id', $id)->orderBy('id', 'DESC')->get();
            } else {
                $data = Kendaraan_Out::where('sub_divisi_id', $id)->whereBetween('created_at', [$request->tglawal, $request->tglakhir])->orderBy('id', 'DESC')->get();
            }
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('tanggal', function ($row) {
                    $tanggal = $row->tanggal == '' ? '-' : Carbon::parse($row->tanggal)->translatedFormat('d-m-Y');

                    $result = '<div  class="fs_tabel ">'.$tanggal.'</div>';

                    return $result;
                })
                ->addColumn('kendaraan', function ($row) {
                    $kendaraan = $row->kendaraan_id == '' ? '-' :  $row->kendaraan->kode_kendaraan;

                    $result = '<a href="/superadmin_kendaraan/show_barang_keluar/'.$row->id.'/'.$row->sub_divisi_id.'" class="fs_tabel fw-bold ">'.$kendaraan.'</a>';

                    return $result;
                })
                ->addColumn('nomor', function ($row) {
                    $nomor = $row->no_aset ;

                    $result = '<a href="/superadmin_kendaraan/show_barang_keluar/'.$row->id.'/'.$row->sub_divisi_id.'" class="fs_tabel fw-bold ">'.$nomor.'</a>';

                    return $result;
                })
                ->addColumn('nama_kendaraan', function ($row) {
                    $nama_kendaraan = $row->kendaraan_id == '' ? '-' :  $row->kendaraan->nama_kendaraan;

                    $result = '<div  class="fs_tabel ">'.$nama_kendaraan.'</div>';

                    return $result;
                })
                ->addColumn('merek', function ($row) {
                    $merek = $row->kendaraan_id == '' ? '-' :  $row->kendaraan->merek;

                    $result = '<div  class="fs_tabel ">'.$merek.'</div>';

                    return $result;
                })
                ->addColumn('nopol', function ($row) {
                    $nopol = $row->kendaraan_in_id == '' ? '-' :  $row->kendaraan_in->nopol;

                    $result = '<div  class="fs_tabel ">'.$nopol.'</div>';

                    return $result;
                })
                ->addColumn('warna', function ($row) {
                    $warna = $row->kendaraan_in_id == '' ? '-' :  $row->kendaraan_in->warna;

                    $result = '<div  class="fs_tabel ">'.$warna.'</div>';

                    return $result;
                })
                ->addColumn('nomor_rangka', function ($row) {
                    $nomor_rangka = $row->kendaraan_in_id == '' ? '-' :  $row->kendaraan_in->no_rangka;

                    $result = '<div  class="fs_tabel ">'.$nomor_rangka.'</div>';

                    return $result;
                })
                ->addColumn('nomor_mesin', function ($row) {
                    $nomor_mesin = $row->kendaraan_in_id == '' ? '-' :  $row->kendaraan_in->no_mesin;

                    $result = '<div  class="fs_tabel ">'.$nomor_mesin.'</div>';

                    return $result;
                })
                ->addColumn('tahun', function ($row) {
                    $tahun = $row->kendaraan_in_id == '' ? '-' :  $row->kendaraan_in->tahun;

                    $result = '<div  class="fs_tabel ">'.$tahun.'</div>';

                    return $result;
                })
                ->addColumn('jumlah', function ($row) {
                    $jumlah = $row->kendaraan_in_id == '' ? '-' :  $row->kendaraan_in->jumlah;

                    $result = '<div  class="fs_tabel ">'.$jumlah.'</div>';

                    return $result;
                })
                ->addColumn('aset', function ($row) {
                    $aset = $row->kendaraan_in_id == '' ? '-' :  $row->kendaraan_in->aset;

                    $result = '<div  class="fs_tabel  ">'.$aset.'</div>';

                    return $result;
                })
              
                ->addColumn('kategori', function ($row) {
                    $kategori = $row->kendaraan_id == '' ? '-' :  $row->kendaraan->kategori->nama_kategori;

                    $result = '<div  class="fs_tabel ">'.$kategori.'</div>';

                    return $result;
                })
                ->addColumn('sub_divisi', function ($row) {
                    $sub_divisi = $row->sub_divisi_id == '' ? '-' :  $row->sub_divisi->nama_sub_divisi;

                    $result = '<div  class="fs_tabel ">'.$sub_divisi.'</div>';

                    return $result;
                })
                ->addColumn('proyek', function ($row) {
                    $proyek = $row->proyek_id == '' ? '-' :  $row->proyek->nama_proyek;

                    $result = '<div  class="fs_tabel ">'.$proyek.'</div>';

                    return $result;
                })
                ->addColumn('divisi', function ($row) {
                    $divisi = $row->n_divisi == '' ? '-' :  $row->divisi->nama_divisi;

                    $result = '<div  class="fs_tabel ">'.$divisi.'</div>';

                    return $result;
                })
                ->addColumn('perusahaan', function ($row) {
                    $perusahaan = $row->perusahaan_id == '' ? '-' :  $row->perusahaan->kode_perusahaan;

                    $result = '<div  class="fs_tabel ">'.$perusahaan.'</div>';

                    return $result;
                })
                ->addColumn('created_at', function ($row) {
                    $tanggal_input = $row->created_at == '' ? '-' : Carbon::parse($row->creted_at)->translatedFormat('d-m-Y');

                    $result = '<div  class="fs_tabel ">'.$tanggal_input.'</div>';

                    return $result;
                })
                ->addColumn('gambar', function ($row) {
                    $result = '<a target="_blank" rel="noopener noreferrer" href="/kendaraan/view_gambar/'.$row->id.'"  class="text-center "><i class="bi bi-card-image"></i></a>';

                    return $result;
                })
                ->addColumn('opsi', function ($row) {
                    $result = '<div  class="bg-transparent d-flex flex-row text-center ">
                    <a href="/superadmin_kendaraan/show_barang_keluar/'.$row->id.'/'.$row->sub_divisi_id.'" class="badge-edit text-light me-1"><i class="bi bi-pencil-square"></i></a>
                    <a href="/superadmin_kendaraan/kendaraan/keluar/'.$row->id.'" class="badge-delete text-light"  data-confirm-delete="true" ><i class="bi bi-trash"></i></a>
                    </div>';

                    return $result;
                })
                ->rawColumns([
                    'tanggal', 
                    'nomor', 
                    'kendaraan', 
                    'nama_kendaraan', 
                    'merek', 
                    'nopol', 
                    'warna', 
                    'nomor_rangka', 
                    'nomor_mesin', 
                    'tahun', 
                    'jumlah', 
                    'aset', 
                    'kategori', 
                    'sub_divisi', 
                    'proyek',
                    'divisi',
                    'perusahaan',
                    'created_at',
                    'gambar',
                    'opsi',
                    ])->make(true);
        }
    }


    public function print(Request $request, $id)
    {

        // dd($id);
        if ($request->tglawal) {
            $data['data'] = Kendaraan_Out::where('sub_divisi_id', $id)->whereBetween('created_at', [$request->tglawal, $request->tglakhir])->orderBy('id', 'DESC')->get();;
        } else {
            $data['data'] = Kendaraan_Out::where('sub_divisi_id', $id)->orderBy('id', 'DESC')->get();
        }

        $item = Sub_Divisi::where('id', $id)->first();

        $data["title"] = "Print Barang Masuk";
        $data['web'] = Kendaraan_Out::first();
        $data['tglawal'] = $request->tglawal;
        $data['tglakhir'] = $request->tglakhir;
        return view('superadmin.perusahaan.kendaraan.keluar.print', $data, [
            'item' => $item
        ]);
    }

    public function cari_barang($id)
    {

        // dd($id);
        // $data = Gs_Barangs::orderBy('id', 'asc');
        $data_data = Sub_Divisi::where('id', $id)->first();

        $data = Kendaraan_In::where('sub_divisi_id', $id)->orderBy('id', 'desc');
        // $data = $perusahaan->where('proyek_id', '1')->orderBy('kode_barang', 'asc');
        // $data = Gs_Barangs::orderBy('id', 'asc');

        if (request('cari_barang')) {
            $data->where('nopol', 'like', '%' . request('cari_barang') . '%');
        }
        return view('superadmin.perusahaan.kendaraan.keluar.barang', [
            'data_data' => $data_data,
            'data' => $data->paginate(),
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create($id)
    {
        //
        $kendaraan = Kendaraan::where('kode_kendaraan', $id)->first();
        $data_data = Kendaraan_In::where('kendaraan_id', $kendaraan->id)->first();

        return view('superadmin.perusahaan.kendaraan.keluar.add', [
            'data_data' =>  $data_data,
            'perusahaan' => Perusahaan::all()
            // 'kategori' =>  Kategori::all()
            
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, $id)
    {
        //
        $notif['kendaraan_in_id'] = [
            'required' => 'Kendaraan Sudah Terpakai',
        ];
        $notif['no_aset'] = [
            'required' => 'Nomor Aset Sudah Ada',
        ];
        $data = $request->validate([
            'perusahaan_id' => 'required',
            'divisi_id' => 'required',
            'sub_divisi_id' => 'required',
            'proyek_id' => 'required',
            'kendaraan_id' => 'required',
            'kendaraan_in_id' => 'required|unique:kendaraan__outs',
            'no_aset' => 'required|unique:kendaraan__outs',
            'jumlah' => 'required',
            'penerima' => 'required',
            'nik' => 'required',
            'pemakai' => 'required',
            'n_divisi' => 'required',
            'ket_plat' => 'required',
            'ket_stnk' => 'required',
            'lokasi' => 'required',
            'tanggal' => 'required',
            'keterangan' => 'required',
        ], $notif);

        // dd($data);
        Kendaraan_Out::create($data);
        return redirect('/superadmin_kendaraan/kendaraan/keluar/'.$id)->with('toast_success', 'Data Ditambahkan !');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
        // $data_data = Kendaraan_Out::where('kode_kendaraan', $id)->first();

        return view('superadmin.perusahaan.kendaraan.keluar.edit', [
            'data_data' =>  Kendaraan_Out::find($id),
            'perusahaan' =>  Perusahaan::all()
            
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id, $it)
    {
        //
        $notif['kendaraan_in_id'] = [
            'required' => 'Kendaraan Sudah Terpakai',
        ];
        $notif['no_aset'] = [
            'required' => 'Nomor Aset Sudah Ada',
        ];
        $data = $request->validate([
            // 'perusahaan_id' => 'required',
            // 'divisi_id' => 'required',
            // 'sub_divisi_id' => 'required',
            // 'proyek_id' => 'required',
            // 'kendaraan_id' => 'required',
            // 'kendaraan_in_id' => 'required|unique:kendaraan__outs',
            'no_aset' => 'required',
            // 'jumlah' => 'required',
            'penerima' => 'required',
            'nik' => 'required',
            'pemakai' => 'required',
            'n_divisi' => 'required',
            'ket_plat' => 'required',
            'ket_stnk' => 'required',
            'lokasi' => 'required',
            'tanggal' => 'required',
            'keterangan' => 'required',
        ], $notif);

        Kendaraan_Out::where('id', $id)->update($data);
        return redirect('/superadmin_kendaraan/kendaraan/keluar/'.$it)->with('toast_success', 'Data Kendaraan di Update ');


    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        Kendaraan_Out::destroy($id);
        Servis::where('kendaraan_out_id','=', $id)->delete();
        Servis_riwayat::where('kendaraan_out_id','=', $id)->delete();
        Pajak::where('kendaraan_out_id','=', $id)->delete();
        Pajak_Riwayat::where('kendaraan_out_id','=', $id)->delete();

        return back()->with('toast_success', 'Data Barang Di Hapus');
    }
}
