<?php

namespace App\Http\Controllers\Superadmin\Perusahaan\Kendaraan;

use App\Http\Controllers\Controller;
use App\Models\Kendaraan\Kendaraan;
use App\Models\Kendaraan\Kendaraan_In;
use App\Models\Kendaraan\Kendaraan_Out;
use App\Models\Kendaraan\Pajak;
use App\Models\Superadmin\Sub_Divisi;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class Superadmin_Kendaraan_Controller extends Controller
{
    //

    public function index($id)
    {
        $data_data = Sub_Divisi::where('id', $id)->first();

        $jumlah_kendaraan = Kendaraan::where('sub_divisi_id', $id)->count('id');
      
        $pajak = Pajak::where('sub_divisi_id', $id)->where('pembayaran_pajak', '<=', Carbon::now())->count('pembayaran_pajak');
        $stnk = Pajak::where('sub_divisi_id', $id)->where('pembayaran_stnk', '<=', Carbon::now())->count('pembayaran_stnk');


        return view('superadmin.perusahaan.kendaraan.index', [
            'data_data' => $data_data,
            'id' => $id,
            'jumlah_kendaraan' => $jumlah_kendaraan,
            'pajak' => $pajak,
            'stnk' => $stnk,
            // 'jumlah_perawatan' => $jumlah_perawatan,
            // 'jumlah_keluar' => $jumlah_keluar,


            ($title = 'Hapus Data'),
            ($text = 'Apakah anda yakin ingin menghapus?'),
            confirmDelete($title, $text),
        ]);
    }

    public function get_data(Request $request, $id)
    {
        // $data_proyek = Proyek::where('id', $id)->first();
        // $data_perusahaan = Sub_Divisi::where('divisi_id', '1')->first();

        // $id_perusahaan = $data_perusahaan->divisi->perusahaan->id;
        // $id_divisi = $data_perusahaan->divisi_id;
        // $id_sub_divisi = $data_perusahaan->id;

        if ($request->ajax()) {
            // $sub_divisi = Sub_Divisi::where('kode_sub_divisi', $id)->first();
            // $data = Consumable::orderBy('id', 'DESC')->get();
            $data = Kendaraan::where('sub_divisi_id', $id)->orderBy('kode_kendaraan', 'asc')->get();
            // ->where('sub_divisi_id', $id_sub_divisi)
            // ->where('proyek_id', $data_proyek->id)->orderBy('kode_barang', 'asc');

            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('stokawal', function ($row) {
                    $result = '<div class=""> <p class=fs-6> ' . $row->kode_kendaraan . ' </p></div>';
                    // $result = '<a href="example.com/member/">'.$row->kode_barang.'</a>';

                    return $result;
                })
                ->addColumn('kode', function ($row) {
                    $result = '<a href="/superadmin_kendaraan/show/'.$row->id.'/'.$row->sub_divisi_id.'" class="text-decoration-none fw-bold " style="font-size: 14px">'.$row->kode_kendaraan.'</a>';

                    return $result;
                })
                
                ->addColumn('jmlmasuk', function ($row) use ($request) {
                    if ($request->tglawal == '') {
                        $jmlmasuk = Kendaraan_In::leftJoin('kendaraans', 'kendaraans.id', '=', 'kendaraan__ins.kendaraan_id')
                            ->where('kendaraan__ins.kendaraan_id', '=', $row->id)
                            ->sum('kendaraan__ins.jumlah');
                    } else {
                        $jmlmasuk = Kendaraan_In::leftJoin('kendaraans', 'kendaraans.id', '=', 'kendaraan__ins.kendaraan_id')
                            ->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])
                            ->where('kendaraan__ins.kendaraan_id', '=', $row->id)
                            ->sum('kendaraan__ins.jumlah');
                    }

                    $result = '<span class="">' . $jmlmasuk . '</span>';

                    return $result;
                })
                ->addColumn('jmlkeluar', function ($row) use ($request) {
                    if ($request->tglawal) {
                        $jmlkeluar = Kendaraan_Out::leftJoin('kendaraans', 'kendaraans.id', '=', 'kendaraan__outs.kendaraan_id')
                            ->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])
                            ->where('kendaraan__outs.kendaraan_id', '=', $row->id)
                            ->sum('kendaraan__outs.jumlah');
                    } else {
                        $jmlkeluar = Kendaraan_Out::leftJoin('kendaraans', 'kendaraans.id', '=', 'kendaraan__outs.kendaraan_id')
                        ->where('kendaraan__outs.kendaraan_id', '=', $row->id)
                            ->sum('kendaraan__outs.jumlah');
                    }

                    $result = '<span class="">' . $jmlkeluar . '</span>';

                    return $result;
                })
                ->addColumn('jumlah', function ($row) use ($request) {
                    if ($request->tglawal == '') {
                        $jmlmasuk = Kendaraan_In::leftJoin('kendaraans', 'kendaraans.id', '=', 'kendaraan__ins.kendaraan_id')
                        ->where('kendaraan__ins.kendaraan_id', '=', $row->id)
                        ->sum('kendaraan__ins.jumlah');
                    } else {
                        $jmlmasuk =Kendaraan_In::leftJoin('kendaraans', 'kendaraans.id', '=', 'kendaraan__ins.kendaraan_id')
                        ->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])
                        ->where('kendaraan__ins.kendaraan_id', '=', $row->id)
                        ->sum('kendaraan__ins.jumlah');
                        // $jmlmasuk = Gs_In_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__in__barangs.gs_barang_id')->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])->where('gs__in__barangs.gs_barang_id', '=', $row->id)->sum('gs__in__barangs.jumlah');
                    }

                    if ($request->tglawal) {
                        $jmlkeluar = Kendaraan_Out::leftJoin('kendaraans', 'kendaraans.id', '=', 'kendaraan__outs.kendaraan_id')
                        ->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])
                        ->where('kendaraan__outs.kendaraan_id', '=', $row->id)
                        ->sum('kendaraan__outs.jumlah');
                        // $jmlkeluar = Gs_Out_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__out__barangs.gs_barang_id')->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])->where('gs__out__barangs.gs_barang_id', '=', $row->id)->sum('gs__out__barangs.jumlah');
                    } else {
                        $jmlkeluar = Kendaraan_Out::leftJoin('kendaraans', 'kendaraans.id', '=', 'kendaraan__outs.kendaraan_id')
                        ->where('kendaraan__outs.kendaraan_id', '=', $row->id)
                            ->sum('kendaraan__outs.jumlah');
                    }

                    $totalstok = $jmlmasuk - $jmlkeluar;
                    if ($totalstok == 0) {
                        $result = '<span class="">' . $totalstok . '</span>';
                    } elseif ($totalstok > 0) {
                        $result = '<span class="text-success">' . $totalstok . '</span>';
                    } else {
                        $result = '<span class="text-danger">' . $totalstok . '</span>';
                    }

                    return $result;
                })
                ->addColumn('totalstok', function ($row) use ($request) {
                    if ($request->tglawal == '') {
                        $jmlmasuk = Kendaraan_In::leftJoin('kendaraans', 'kendaraans.id', '=', 'kendaraan__ins.kendaraan_id')
                        ->where('kendaraan__ins.kendaraan_id', '=', $row->id)
                        ->sum('kendaraan__ins.jumlah');
                    } else {
                        $jmlmasuk = Kendaraan_In::leftJoin('kendaraans', 'kendaraans.id', '=', 'kendaraan__ins.kendaraan_id')
                        ->where('kendaraan__ins.kendaraan_id', '=', $row->id)
                        ->sum('kendaraan__ins.jumlah');
                        // $jmlmasuk = Gs_In_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__in__barangs.gs_barang_id')->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])->where('gs__in__barangs.gs_barang_id', '=', $row->id)->sum('gs__in__barangs.jumlah');
                    }

                    if ($request->tglawal) {
                        $jmlkeluar = Kendaraan_Out::leftJoin('kendaraans', 'kendaraans.id', '=', 'kendaraan__outs.kendaraan_id')
                        ->where('kendaraan__outs.kendaraan_id', '=', $row->id)
                            ->sum('kendaraan__outs.jumlah');
                        // $jmlkeluar = Gs_Out_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__out__barangs.gs_barang_id')->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])->where('gs__out__barangs.gs_barang_id', '=', $row->id)->sum('gs__out__barangs.jumlah');
                    } else {
                        $jmlkeluar = Kendaraan_Out::leftJoin('kendaraans', 'kendaraans.id', '=', 'kendaraan__outs.kendaraan_id')
                        ->where('kendaraan__outs.kendaraan_id', '=', $row->id)
                            ->sum('kendaraan__outs.jumlah');
                    }

                    $totalstok = $jmlmasuk - $jmlkeluar;
                    if ($totalstok == 0) {
                        $result = '<span class="">' . $totalstok . '</span>';
                    } elseif ($totalstok > 0) {
                        $result = '<span class="text-success">' . $totalstok . '</span>';
                    } else {
                        $result = '<span class="text-danger">' . $totalstok . '</span>';
                    }

                    return $result;
                })
                
                ->addColumn('opsi', function ($row) {
                    // $result = '<span class="badge badge-success text-primary"> '.$row->id.'</span>';
                    $result = '<div class=""><a class="badge-edit text-light text-decoration-none" href="/superadmin_kendaraan/show/' . $row->id . '/' . $row->sub_divisi_id . '">Detail</a></div>';

                    return $result;
                })
                ->rawColumns(['kode','stokawal', 'jmlmasuk', 'jmlkeluar', 'totalstok', 'opsi'])
                ->make(true);
        }
    }

    public function print(Request $request, $id)
    {
        $data['data'] = Kendaraan::where('sub_divisi_id', $id)->orderBy('kode_kendaraan', 'asc')->get();

        $item = Sub_Divisi::where('id', $id)->first();

        $data['title'] = 'Print Barang Masuk';
        $data['web'] = Kendaraan::first();
        $data['tglawal'] = $request->tglawal;
        $data['tglakhir'] = $request->tglakhir;
        return view('superadmin.perusahaan.kendaraan.print', $data, [
            'item' => $item
        ]);
    }

    public function show(string $id, $it)
    {
        //
        $data_data = Sub_Divisi::where('id', $it)->first();
        $barang = Kendaraan::where('id', $id )->first();

        // dd($barang);

        $in_barang = Kendaraan_In::where('kendaraan_id', $barang->id)->orderBy('id', 'desc');
        $out_barang = Kendaraan_Out::where('kendaraan_id', $barang->id)->orderBy('id', 'desc');
        
        $masuk = Kendaraan_In::where('kendaraan_id', $barang->id)->sum('jumlah');
        $keluar = Kendaraan_Out::where('kendaraan_id', $barang->id)->sum('jumlah');

        return view('superadmin.perusahaan.kendaraan.show', [
            'data_data' => $data_data,
        //   'data' => $data,
            'barang' => $barang,
            'in_barang' => $in_barang->paginate(10),
            'out_barang' => $out_barang->paginate(10),
            'masuk' => $masuk,
            'keluar' => $keluar


        ]);
    }

    public function gambar($id)
    {
        return view('superadmin.perusahaan.view_gambar', [
           
            'item' => Kendaraan_In::find($id),
        ]);
    }

}
