<?php

namespace App\Http\Controllers\Superadmin\Perusahaan\Inventaris;

use App\Http\Controllers\Controller;
use App\Models\Inventaris\Inventaris_In;
use App\Models\Inventaris\Inventaris_Out;
use App\Models\Inventaris\Perawatan;
use App\Models\Inventaris\Perawatan_Riwayat;
use App\Models\Superadmin\Perusahaan;
use App\Models\Superadmin\Sub_Divisi;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class Superadmin_Inventaris_Perawatan_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index($id)
    {
        //
        $data_data = Sub_Divisi::where('id', $id)->first();

        // $data = Consumable_In::where('sub_divisi_id', $id)->orderBy('id', 'asc');
        $mytime = Carbon::now();
        // $perawatan = Perawatan::where('sub_divisi_id', $id)->count('servis_berikutnya', '>', $mytime);
        $perawatan = Perawatan::where('sub_divisi_id', $id)->where('servis_berikutnya', '<=', $mytime)->count('servis_berikutnya');

        return view('superadmin.perusahaan.inventaris.perawatan.index', [
            'data_data' => $data_data,
            'id' => $id,
            'total' => $perawatan,
            // 'date' => $mytime,
            // 'data' => $data->paginate(),

            ($title = 'Hapus Data'),
            ($text = 'Apakah anda yakin ingin menghapus?'),
            confirmDelete($title, $text),
        ]);
    }

    public function get_data(Request $request, $id)
    {
        if ($request->ajax()) {
            if ($request->tglawal == '') {
                $data = Perawatan::where('sub_divisi_id', $id)->orderBy('updated_at', 'desc')->get();
            } else {
                $data = Perawatan::where('sub_divisi_id', $id)
                    ->whereBetween('created_at', [$request->tglawal, $request->tglakhir])
                    ->orderBy('updated_at', 'asc')
                    ->get();
            }
            return DataTables::of($data)
                ->addIndexColumn()

                ->addColumn('barang', function ($row) {
                    $barang = $row->inventaris_id == '' ? '-' : $row->inventaris->kode_barang;

                    $result = '<a href="/superadmin_inventaris/perawatan/show/' . $row->id . '/' . $row->sub_divisi_id . '" class="fs_tabel fw-bold ">' . $barang . '</a>';

                    return $result;
                })
                ->addColumn('nomor_aset', function ($row) {
                    $nomor_aset = $row->inventaris_out_id == '' ? '-' : $row->inventaris_out->nomor_aset;

                    $result = '<a href="/superadmin_inventaris/perawatan/show/' . $row->id . '/' . $row->sub_divisi_id . '" class="fs_tabel fw-bold ">' . $nomor_aset . '</a>';

                    return $result;
                })
                ->addColumn('nomor_seri', function ($row) {
                    $nomor_seri = $row->inventaris_out_id == '' ? '-' : $row->inventaris_out->nomor_seri;

                    $result = '<div  class="fs_tabel ">' . $nomor_seri . '</div>';

                    return $result;
                })
                ->addColumn('nama_barang', function ($row) {
                    $n_barang = $row->inventaris_id == '' ? '-' : $row->inventaris->nama_barang;

                    $result = '<div  class="fs_tabel ">' . $n_barang . '</div>';

                    return $result;
                })
                ->addColumn('merek', function ($row) {
                    $merek = $row->inventaris_id == '' ? '-' : $row->inventaris->merek;

                    $result = '<div  class="fs_tabel ">' . $merek . '</div>';

                    return $result;
                })
                ->addColumn('kategori', function ($row) {
                    $kategori = $row->inventaris_id == '' ? '-' : $row->inventaris->kategori->nama_kategori;

                    $result = '<div  class="fs_tabel ">' . $kategori . '</div>';

                    return $result;
                })
                ->addColumn('tgl_servis', function ($row) {
                    $tgl_servis = $row->tanggal_servis == '' ? '-' : Carbon::parse($row->tanggal_servis)->translatedFormat('d-m-Y');

                    $result = '<div  class="fs_tabel ">' . $tgl_servis . '</div>';

                    return $result;
                })
                ->addColumn('servis_next', function ($row) {
                    $mytime = Carbon::now();

                    $servis_next = $row->servis_berikutnya == '' ? '-' : Carbon::parse($row->servis_berikutnya);

                    if ($mytime >= $servis_next) {
                        # code...
                        $result = '<div  class="fs_tabel  text-danger">' . Carbon::parse($servis_next)->translatedFormat('d-m-Y') . ' (Servis)</div>';
                    } else {
                        # code...
                        $result = '<div  class="fs_tabel text-primary ">' .Carbon::parse($servis_next)->translatedFormat('d-m-Y')  . '</div>';
                    }

                    return $result;
                })
                ->addColumn('hari', function ($row) {
                    
                    $date1 = Carbon::now();

                    $date2 = $row->servis_berikutnya == '' ? '-' : Carbon::parse($row->servis_berikutnya);

                    $hari = $date1->diffInDays($date2);


                    // $hari= calculateDaysDifference($mytime, $servis_next) ;
                    if ($date1 >= $date2) {
                        # code...
                        $result = '<div  class="fs_tabel  text-danger">' . $hari . ' Hari (Lewat)</div>';
                    } else {
                        # code...
                        $result = '<div  class="fs_tabel text-primary ">Sisa ' . $hari . ' Hari</div>';
                    }

                    return $result;
                })
                ->addColumn('lokasi', function ($row) {
                    $lokasi = $row->inventaris_out_id == '' ? '-' : $row->inventaris_out->lokasi;

                    $result = '<div  class="fs_tabel ">' . $lokasi . '</div>';

                    return $result;
                })
                // ->addColumn('tanggal_now', function ($row) {
                //     $tanggal_now = $mytime = Carbon::now();
                //     echo $mytime->toDateTimeString();

                //     $result = '<div  class="fs_tabel ">'.$tanggal_now.'</div>';

                //     return $result;
                // })

                ->addColumn('opsi', function ($row) {
                    $result =
                        '<div  class="bg-transparent d-flex flex-row text-center ">
                <a href="/superadmin_inventaris/perawatan/show/' .
                        $row->id .
                        '/' .
                        $row->sub_divisi_id .
                        '" class="badge-edit text-light me-1"><i class="bi bi-pencil-square"></i></a>
                <a href="/superadmin_inventaris/perawatan/' .
                        $row->id .
                        '" class="badge-delete text-light"  data-confirm-delete="true" ><i class="bi bi-trash"></i></a>
                </div>';

                    return $result;
                })
                ->rawColumns(['barang', 'nomor_aset', 'nomor_seri', 'nama_barang', 'merek', 'kategori', 'tgl_servis', 'servis_next', 'lokasi', 'hari', 'opsi'])
                ->make(true);
        }
    }

    public function print(Request $request, $id)
    {
        // dd($id);
        if ($request->tglawal) {
            $data['data'] = Perawatan::where('sub_divisi_id', $id)
                ->whereBetween('created_at', [$request->tglawal, $request->tglakhir])
                ->orderBy('id', 'DESC')
                ->get();
        } else {
            $data['data'] = Perawatan::where('sub_divisi_id', $id)->orderBy('id', 'DESC')->get();
        }

        $item = Sub_Divisi::where('id', $id)->first();

        $data['title'] = 'Print Barang Keluar';
        $data['web'] = Perawatan::first();
        $data['tglawal'] = $request->tglawal;
        $data['tglakhir'] = $request->tglakhir;
        return view('superadmin.perusahaan.inventaris.perawatan.print', $data, [
            'item' => $item,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */

    public function cari_barang($id)
    {
        // dd($id);
        // $data = Gs_Barangs::orderBy('id', 'asc');
        $data_data = Sub_Divisi::where('id', $id)->first();

        $data = Inventaris_Out::where('sub_divisi_id', $id)->orderBy('nomor_aset', 'asc');
        // $data = $perusahaan->where('proyek_id', '1')->orderBy('kode_barang', 'asc');
        // $data = Gs_Barangs::orderBy('id', 'asc');

        if (request('cari_barang')) {
            $data->where('nomor_aset', 'like', '%' . request('cari_barang') . '%')->orWhere('nomor_seri', 'like', '%' . request('cari_barang') . '%');
        }
        return view('superadmin.perusahaan.inventaris.perawatan.barang', [
            'data_data' => $data_data,
            'data' => $data->paginate(),
        ]);
    }

    public function create($id)
    {
        //
        $data_data = Inventaris_Out::where('id', $id)->first();

        return view('superadmin.perusahaan.inventaris.perawatan.add', [
            'data_data' => $data_data,
            'perusahaan' => Perusahaan::all(),
            // 'kategori' =>  Kategori::all()
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, $id)
    {
        //
        $notif['inventaris_out_id'] = [
            'required' => 'Nomor Aset Servis sudah ada !!',
        ];
        
        $data = $request->validate([
            'perusahaan_id' => 'required',
            'divisi_id' => 'required',
            'sub_divisi_id' => 'required',
            'proyek_id' => 'required',
            'inventaris_id' => 'required',
            'inventaris_out_id' => 'required|unique:perawatans',
            'tanggal_servis' => 'required',
            'servis_berikutnya' => 'required',
            'teknisi' => 'required',
            'keterangan' => 'required',
        ], $notif);

        // dd($data);
        Perawatan::create($data);
        return redirect('/superadmin_inventaris/perawatan/' . $id)->with('toast_success', 'Data Ditambahkan !');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id, $it)
    {
        //
     
        // $perawatan = Perawatan::where('inventaris_out_id', $id);
        $riwayat = Perawatan_Riwayat::where('perawatan_id', $id)->orderBy('id', 'desc');


        return view('superadmin.perusahaan.inventaris.perawatan.edit', [
            'data_data' => Perawatan::find($id),
            'perusahaan' => Perusahaan::all(),
            'riwayat' =>  $riwayat->paginate(10),
  


            ($title = 'Hapus Data'),
            ($text = 'Apakah anda yakin ingin menghapus?'),
            confirmDelete($title, $text),
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id, $it)
    {
        //
        $data = $request->validate([
            // 'perusahaan_id' => 'required',
            // 'divisi_id' => 'required',
            // 'sub_divisi_id' => 'required',
            // 'proyek_id' => 'required',
            // 'inventaris_id' => 'required',
            // 'inventaris_out_id' => 'required',
            'tanggal_servis' => 'required',
            'servis_berikutnya' => 'required',
            'teknisi' => 'required',
            'keterangan' => 'required',
        ]);

        $data2 = $request->validate([
            'perusahaan_id' => 'required',
            'divisi_id' => 'required',
            'sub_divisi_id' => 'required',
            'proyek_id' => 'required',
            'inventaris_id' => 'required',
            'inventaris_out_id' => 'required',
            'perawatan_id' => 'required',
            'servis' => 'required',
            'berikut' => 'required',
            'teknisi' => 'required',
            'keterangan' => 'required',
        ]);

        // dd($data, $data2);
        Perawatan_Riwayat::create($data2);
        Perawatan::where('id', $id)->update($data);
        return back()->with('toast_success', 'Data Tersimpan !!');
        // return redirect('/superadmin_inventaris/perawatan/' . $it)->with('toast_success', 'Data di Update !');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        Perawatan::destroy($id);
        Perawatan_Riwayat::where('perawatan_id','=', $id)->delete();
        return back()->with('toast_success', 'Data Di Hapus !!');
    }
}
