<?php

namespace App\Http\Controllers\Superadmin\Perusahaan\Inventaris;

use App\Http\Controllers\Controller;
use App\Models\Inventaris\Inventaris;
use App\Models\Inventaris\Inventaris_Out;
use App\Models\Inventaris\Perawatan;
use App\Models\Inventaris\Perawatan_Riwayat;
use App\Models\Kendaraan\Servis;
use App\Models\Superadmin\Divisi;
use App\Models\Superadmin\Perusahaan;
use App\Models\Superadmin\Sub_Divisi;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class Superadmin_Inventaris_Out_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index($id)
    {
        //
        $data_data = Sub_Divisi::where('id', $id)->first();

        // $data = Consumable_In::where('sub_divisi_id', $id)->orderBy('id', 'asc');

        return view('superadmin.perusahaan.inventaris.keluar.index', [
            'data_data' =>  $data_data,
            'id' => $id,
            // 'data' => $data->paginate(),
     
             $title = 'Hapus Data',
             $text = "Apakah anda yakin ingin menghapus?",
             confirmDelete($title, $text),
             
        ]);
    }

    public function get_data(Request $request, $id) 
    {

        if ($request->ajax()) {
            if ($request->tglawal == '') {
                $data = Inventaris_Out::where('sub_divisi_id', $id)->orderBy('id', 'DESC')->get();
            } else {
                $data = Inventaris_Out::where('sub_divisi_id', $id)->whereBetween('created_at', [$request->tglawal, $request->tglakhir])->orderBy('id', 'DESC')->get();
            }
            return DataTables::of($data)
            ->addIndexColumn()
            ->addColumn('tanggal', function ($row) {
                $tanggal = $row->tanggal == '' ? '-' : Carbon::parse($row->tanggal)->translatedFormat('d-m-Y');

                $result = '<div  class="fs_tabel ">'.$tanggal.'</div>';

                return $result;
            })
            ->addColumn('barang', function ($row) {
                $barang = $row->inventaris_id == '' ? '-' :  $row->inventaris->kode_barang;

                $result = '<a href="/superadmin_inventaris/show_barang_keluar/'.$row->id.'/'.$row->sub_divisi_id.'" class="fs_tabel fw-bold ">'.$barang.'</a>';

                return $result;
            })
            ->addColumn('nomor', function ($row) {
                $nomor = $row->nomor_aset ;

                $result = '<a href="/superadmin_inventaris/show_barang_keluar/'.$row->id.'/'.$row->sub_divisi_id.'" class="fs_tabel fw-bold ">'.$nomor.'</a>';

                return $result;
            })
            ->addColumn('nama_barang', function ($row) {
                $n_barang = $row->inventaris_id == '' ? '-' :  $row->inventaris->nama_barang;

                $result = '<div  class="fs_tabel ">'.$n_barang.'</div>';

                return $result;
            })
            ->addColumn('merek', function ($row) {
                $merek = $row->inventaris_id == '' ? '-' :  $row->inventaris->merek;

                $result = '<div  class="fs_tabel ">'.$merek.'</div>';

                return $result;
            })
            ->addColumn('kategori', function ($row) {
                $kategori = $row->inventaris_id == '' ? '-' :  $row->inventaris->kategori->nama_kategori;

                $result = '<div  class="fs_tabel ">'.$kategori.'</div>';

                return $result;
            })
            ->addColumn('nama_divisi', function ($row) {
                $nama_divisi = $row->n_divisi == '' ? '-' :  $row->divisi->nama_divisi;

                $result = '<div  class="fs_tabel ">'.$nama_divisi.'</div>';

                return $result;
            })
            ->addColumn('sub_divisi', function ($row) {
                $sub_divisi = $row->sub_divisi_id == '' ? '-' :  $row->sub_divisi->nama_sub_divisi;

                $result = '<div  class="fs_tabel ">'.$sub_divisi.'</div>';

                return $result;
            })
            ->addColumn('proyek', function ($row) {
                $proyek = $row->proyek_id == '' ? '-' :  $row->proyek->nama_proyek;

                $result = '<div  class="fs_tabel ">'.$proyek.'</div>';

                return $result;
            })
            ->addColumn('divisi', function ($row) {
                $divisi = $row->divisi_id == '' ? '-' :  $row->divisi->nama_divisi;

                $result = '<div  class="fs_tabel ">'.$divisi.'</div>';

                return $result;
            })
            ->addColumn('perusahaan', function ($row) {
                $perusahaan = $row->perusahaan_id == '' ? '-' :  $row->perusahaan->kode_perusahaan;

                $result = '<div  class="fs_tabel text-center">'.$perusahaan.'</div>';

                return $result;
            })
            ->addColumn('created_at', function ($row) {
                $tanggal_input = $row->created_at == '' ? '-' : Carbon::parse($row->creted_at)->translatedFormat('d-m-Y');

                $result = '<div  class="fs_tabel ">'.$tanggal_input.'</div>';

                return $result;
            })
            ->addColumn('opsi', function ($row) {
                $result = '<div  class="bg-transparent d-flex flex-row text-center ">
                <a href="/superadmin_inventaris/show_barang_keluar/'.$row->id.'/'.$row->sub_divisi_id.'" class="badge-edit text-light me-1"><i class="bi bi-pencil-square"></i></a>
                <a href="/superadmin_inventaris/inventaris/keluar/'.$row->id.'" class="badge-delete text-light"  data-confirm-delete="true" ><i class="bi bi-trash"></i></a>
                </div>';

                return $result;
            })
            ->rawColumns([
                'tanggal', 
                'nomor', 
                'barang', 
                'nama_barang', 
                'merek', 
                'nama_divisi', 
                'kategori', 
                'sub_divisi', 
                'proyek',
                'divisi',
                'perusahaan',
                'created_at',
                'gambar',
                'opsi',
                ])->make(true);
        }
    }

    public function print(Request $request, $id)
    {

        // dd($id);
        if ($request->tglawal) {
            $data['data'] = Inventaris_Out::where('sub_divisi_id', $id)->whereBetween('created_at', [$request->tglawal, $request->tglakhir])->orderBy('id', 'DESC')->get();;
        } else {
            $data['data'] = Inventaris_Out::where('sub_divisi_id', $id)->orderBy('id', 'DESC')->get();
        }

        $item = Sub_Divisi::where('id', $id)->first();

        $data["title"] = "Print Barang Keluar";
        $data['web'] = Inventaris_Out::first();
        $data['tglawal'] = $request->tglawal;
        $data['tglakhir'] = $request->tglakhir;
        return view('superadmin.perusahaan.inventaris.keluar.print', $data, [
            'item' => $item
        ]);
    }


    public function cari_barang($id)
    {

        // dd($id);
        // $data = Gs_Barangs::orderBy('id', 'asc');
        $data_data = Sub_Divisi::where('id', $id)->first();

        $data = Inventaris::where('sub_divisi_id', $id)->orderBy('kode_barang', 'asc');
        // $data = $perusahaan->where('proyek_id', '1')->orderBy('kode_barang', 'asc');
        // $data = Gs_Barangs::orderBy('id', 'asc');

        if (request('cari_barang')) {
            $data->where('kode_barang', 'like', '%' . request('cari_barang') . '%')
            ->orWhere('nama_barang', 'like', '%' . request('cari_barang') . '%')
            ->orWhere('merek', 'like', '%' . request('cari_barang') . '%');
        }
        return view('superadmin.perusahaan.inventaris.keluar.barang', [
            'data_data' => $data_data,
            'data' => $data->paginate(),
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create($id)
    {
        //
        $data_data = Inventaris::where('kode_barang', $id)->first();

        return view('superadmin.perusahaan.inventaris.keluar.add', [
            'data_data' =>  $data_data,
            'perusahaan' => Perusahaan::all(),
            
            // 'kategori' =>  Kategori::all()
            
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, $id)
    {
        //
        $data = $request->validate([
            'perusahaan_id' => 'required',
            'divisi_id' => 'required',
            'sub_divisi_id' => 'required',
            'proyek_id' => 'required',
            'inventaris_id' => 'required',
            'aset' => 'required',
            'nomor_aset' => 'required|unique:inventaris__outs',
            'nomor_seri' => 'required',
            'jumlah' => 'required',
            'satuan' => 'required',
            'nama' => 'required',
            'nik' => 'required',
            'n_divisi' => 'required',
            'lokasi' => 'required',
            'tanggal' => 'required',
            'status' => 'required',
            'keterangan' => 'required',
        ]);

        // dd($data);
        Inventaris_Out::create($data);
        return redirect('/superadmin_inventaris/inventaris/keluar/'.$id)->with('toast_success', 'Data Ditambahkan !');

    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //]
        return view('superadmin.perusahaan.inventaris.keluar.edit', [
            'data_data' =>  Inventaris_Out::find($id),
            'perusahaan' => Perusahaan::all(),
            'divisi' => Divisi::all()
            // 'kategori' =>  Kategori::all()
            
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id, $it)
    {
        //
        $data = $request->validate([
            // 'perusahaan_id' => 'required',
            // 'divisi_id' => 'required',
            // 'sub_divisi_id' => 'required',
            // 'proyek_id' => 'required',
            // 'inventaris_id' => 'required',
            'aset' => 'required',
            'nomor_aset' => 'required',
            'nomor_seri' => 'required',
            'jumlah' => 'required',
            'satuan' => 'required',
            'nama' => 'required',
            'nik' => 'required',
            'n_divisi' => 'required',
            'lokasi' => 'required',
            'tanggal' => 'required',
            'status' => 'required',
            'keterangan' => 'required',
        ]);

        Inventaris_Out::where('id', $id)->update($data);
        return redirect('/superadmin_inventaris/inventaris/keluar/'.$it)->with('toast_success', 'Data di Update !');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        Inventaris_Out::destroy($id);
        Perawatan::where('inventaris_out_id','=', $id)->delete();
        Perawatan_Riwayat::where('inventaris_out_id','=', $id)->delete();
        return back()->with('toast_success', 'Data Barang Di Hapus');
    }
}
