<?php

namespace App\Http\Controllers\Superadmin\Gs\Konstruksi\Consumable;

use App\Http\Controllers\Controller;
use App\Models\Gs\Gs_Barangs;
use App\Models\Gs\Gs_In_Barang;
use App\Models\Gs\Gs_Out_Barang;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class Superadmin_Gs_Konstruksi_Stok_Barang_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        

        return view('superadmin.gs.konstruksi.consumable.gs_stok_barang.index', [
            'menu' => 'BMS',
            'nama_menu' => 'General Support',
            'kategori_menu' => 'Stok Barang',
        //   'data' => $data
            // 'barang' => $barang,
        ]);

      

    }


    public function show_data(Request $request)
    {
        if ($request->ajax()) {
            // $data = Gs_Barangs::orderBy('id', 'DESC')->get();
            $perusahaan = Gs_Barangs::where('perusahaan_id', '1')->first();
            $data = $perusahaan->where('proyek_id', '1')->orderBy('kode_barang', 'asc');
          
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('stokawal', function ($row) {
                    $result = '<div class=""> <p class=fs-6> '.$row->kode_barang.' </p></div>';
                    // $result = '<a href="example.com/member/">'.$row->kode_barang.'</a>';

                    
                    return $result;
                })
                ->addColumn('jmlmasuk', function ($row) use ($request) {
                    if ($request->tglawal == '') {
                        $jmlmasuk = Gs_In_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__in__barangs.gs_barang_id')->where('gs__in__barangs.gs_barang_id', '=', $row->id)->sum('gs__in__barangs.jumlah');
                    } else {
                        $jmlmasuk = Gs_In_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__in__barangs.gs_barang_id')->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])->where('gs__in__barangs.gs_barang_id', '=', $row->id)->sum('gs__in__barangs.jumlah');
                    }

                    $result = '<span class="">'.$jmlmasuk.'</span>';

                    return $result;
       
                })
                ->addColumn('jmlkeluar', function ($row) use ($request) {
                    if ($request->tglawal) {
                        $jmlkeluar = Gs_Out_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__out__barangs.gs_barang_id')->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])->where('gs__out__barangs.gs_barang_id', '=', $row->id)->sum('gs__out__barangs.jumlah');
                    } else {
                        $jmlkeluar = Gs_Out_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__out__barangs.gs_barang_id')->where('gs__out__barangs.gs_barang_id', '=', $row->id)->sum('gs__out__barangs.jumlah');
                    }

                    $result = '<span class="">'.$jmlkeluar.'</span>';

                    return $result;        
                })
                ->addColumn('totalstok', function ($row) use ($request) {
                    if ($request->tglawal == '') {
                        $jmlmasuk = Gs_In_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__in__barangs.gs_barang_id')->where('gs__in__barangs.gs_barang_id', '=', $row->id)->sum('gs__in__barangs.jumlah');
                    } else {
                        $jmlmasuk = Gs_In_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__in__barangs.gs_barang_id')->where('gs__in__barangs.gs_barang_id', '=', $row->id)->sum('gs__in__barangs.jumlah');
                        // $jmlmasuk = Gs_In_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__in__barangs.gs_barang_id')->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])->where('gs__in__barangs.gs_barang_id', '=', $row->id)->sum('gs__in__barangs.jumlah');
                    }


                    if ($request->tglawal) {
                        $jmlkeluar = Gs_Out_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__out__barangs.gs_barang_id')->where('gs__out__barangs.gs_barang_id', '=', $row->id)->sum('gs__out__barangs.jumlah');
                        // $jmlkeluar = Gs_Out_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__out__barangs.gs_barang_id')->whereBetween('tanggal', [$request->tglawal, $request->tglakhir])->where('gs__out__barangs.gs_barang_id', '=', $row->id)->sum('gs__out__barangs.jumlah');
                    } else {
                        $jmlkeluar = Gs_Out_Barang::leftJoin('gs__barangs', 'gs__barangs.id', '=', 'gs__out__barangs.gs_barang_id')->where('gs__out__barangs.gs_barang_id', '=', $row->id)->sum('gs__out__barangs.jumlah');
                    }

                    $totalstok = $jmlmasuk - $jmlkeluar;
                    if($totalstok == 0){
                        $result = '<span class="">'.$totalstok.'</span>';
                    }else if($totalstok > 0){
                        $result = '<span class="text-success">'.$totalstok.'</span>';
                    }else{
                        $result = '<span class="text-danger">'.$totalstok.'</span>';
                    }
                    

                    return $result;
                })
                ->addColumn('opsi', function ($row) {
                    // $result = '<span class="badge badge-success text-primary"> '.$row->id.'</span>';
                    $result = '<div class=""><a class="badge-edit text-light text-decoration-none" href="/sa_master_konstruksi_stok_barang/show/'.$row->kode_barang.'">Detail</a></div>';
                    
                    return $result;
                })
                ->rawColumns(['stokawal', 'jmlmasuk', 'jmlkeluar', 'totalstok', 'opsi'])->make(true);
        }
    }

    public function print($id, Request $request)
    {
       
            $data['data'] = Gs_Barangs::where('perusahaan_id', '1')->first()->where('proyek_id', '1')->orderBy('kode_barang', 'asc')->get();

        $data["title"] = "Print Barang Masuk";
        $data['web'] = Gs_Barangs::first();
        $data['tglawal'] = $request->tglawal;
        $data['tglakhir'] = $request->tglakhir;
        return view('superadmin.gs.konstruksi.consumable.gs_stok_barang.print', $data);
    }


   

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
        $barang = Gs_Barangs::where('kode_barang', $id )->first();

        // dd($barang);

        $in_barang = Gs_In_Barang::where('gs_barang_id', $barang->id)->orderBy('id', 'desc');
        $out_barang = Gs_Out_Barang::where('gs_barang_id', $barang->id)->orderBy('id', 'desc');
        
        $masuk = Gs_In_Barang::where('gs_barang_id', $barang->id)->sum('jumlah');
        $keluar = Gs_Out_Barang::where('gs_barang_id', $barang->id)->sum('jumlah');

        return view('superadmin.gs.konstruksi.consumable.gs_stok_barang.show', [
            'menu' => 'BMS',
            'nama_menu' => 'General Support',
            'kategori_menu' => 'Stok Barang',
        //   'data' => $data,
            'barang' => $barang,
            'in_barang' => $in_barang->paginate(10),
            'out_barang' => $out_barang->paginate(10),
            'masuk' => $masuk,
            'keluar' => $keluar


        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
