<?php

namespace App\Http\Controllers\Superadmin\Gs\Konstruksi\Consumable;

use App\Http\Controllers\Controller;
use App\Models\Gs\Gs_Barangs;
use App\Models\Gs\Gs_In_Barang;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;

class Superadmin_Gs_Konstruksi_In_Barang_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $data = Gs_In_Barang::orderBy('id', 'asc');

        if (request('search')) {
            $data->where('gs_barang_id', 'like', '%' . request('search') . '%')
            ->orWhere('satuan', 'like', '%' . request('search') . '%');
        }
        

        return view('superadmin.gs.konstruksi.consumable.gs_in_barang.index', [
            'menu' => 'BMS',
            'nama_menu' => 'General Support',
            'kategori_menu' => 'Barang Masuk',
            'data' => $data->paginate(),


            $title = 'Hapus Data',
            $text = "Apakah anda yakin ingin menghapus?",
            confirmDelete($title, $text),
        ]);
    }

    public function show_data(Request $request) 
    {



        if ($request->ajax()) {
            if ($request->tglawal == '') {
                $data = Gs_In_Barang::where('perusahaan_id', '1')->first()->where('proyek_id', '1')->orderBy('id', 'DESC');
            } else {
                $data = Gs_In_Barang::where('perusahaan_id', '1')->first()->where('proyek_id', '1')->whereBetween('created_at', [$request->tglawal, $request->tglakhir])->orderBy('id', 'DESC');
            }
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('tanggal', function ($row) {
                    $tanggal = $row->tanggal == '' ? '-' : Carbon::parse($row->tanggal)->translatedFormat('d-m-Y');

                    $result = '<div  class="fs_tabel ">'.$tanggal.'</div>';

                    return $result;
                })
                ->addColumn('barang', function ($row) {
                    $barang = $row->gs_barang_id == '' ? '-' :  $row->gs_barang->kode_barang;

                    $result = '<a href="/sa_master_konstruksi_in_barang/'.$row->id.'" class="fs_tabel fw-bold ">'.$barang.'</a>';

                    return $result;
                })
                ->addColumn('nama_barang', function ($row) {
                    $n_barang = $row->gs_barang_id == '' ? '-' :  $row->gs_barang->nama_barang;

                    $result = '<div  class="fs_tabel ">'.$n_barang.'</div>';

                    return $result;
                })
                ->addColumn('merek', function ($row) {
                    $merek = $row->gs_barang_id == '' ? '-' :  $row->gs_barang->merek;

                    $result = '<div  class="fs_tabel ">'.$merek.'</div>';

                    return $result;
                })
                ->addColumn('kategori', function ($row) {
                    $kategori = $row->gs_barang_id == '' ? '-' :  $row->gs_barang->kategori->nama_kategori;

                    $result = '<div  class="fs_tabel ">'.$kategori.'</div>';

                    return $result;
                })
                ->addColumn('sub_divisi', function ($row) {
                    $sub_divisi = $row->sub_divisi_id == '' ? '-' :  $row->sub_divisi->nama_sub_divisi;

                    $result = '<div  class="fs_tabel ">'.$sub_divisi.'</div>';

                    return $result;
                })
                ->addColumn('proyek', function ($row) {
                    $proyek = $row->proyek_id == '' ? '-' :  $row->proyek->nama_proyek;

                    $result = '<div  class="fs_tabel ">'.$proyek.'</div>';

                    return $result;
                })
                ->addColumn('divisi', function ($row) {
                    $divisi = $row->divisi_id == '' ? '-' :  $row->divisi->kode_divisi;

                    $result = '<div  class="fs_tabel ">'.$divisi.'</div>';

                    return $result;
                })
                ->addColumn('perusahaan', function ($row) {
                    $perusahaan = $row->perusahaan_id == '' ? '-' :  $row->perusahaan->kode_perusahaan;

                    $result = '<div  class="fs_tabel ">'.$perusahaan.'</div>';

                    return $result;
                })
                ->addColumn('created_at', function ($row) {
                    $tanggal_input = $row->created_at == '' ? '-' : Carbon::parse($row->creted_at)->translatedFormat('d-m-Y');

                    $result = '<div  class="fs_tabel ">'.$tanggal_input.'</div>';

                    return $result;
                })
                ->addColumn('gambar', function ($row) {
                    $gambar = $row->image == '' ? '-' : $row->image;

                    $result = '<a target="_blank" rel="noopener noreferrer" href="/sa_master_konstruksi_in_barang/gambar/'.$row->id.'"  class="text-center "><i class="bi bi-card-image"></i></a>';

                    return $result;
                })
                ->addColumn('opsi', function ($row) {
                    $result = '<div  class="bg-transparent d-flex flex-row text-center ">
                    <a href="/sa_master_konstruksi_in_barang/'.$row->id.'" class="badge-edit text-light me-1"><i class="bi bi-pencil-square"></i></a>
                    <a href="/sa_master_konstruksi_in_barang/'.$row->id.'" class="badge-delete text-light"  data-confirm-delete="true" ><i class="bi bi-trash"></i></a>
                    </div>';

                    return $result;
                })
                ->rawColumns([
                    'tanggal', 
                    'barang', 
                    'nama_barang', 
                    'merek', 
                    'kategori', 
                    'sub_divisi', 
                    'proyek',
                    'divisi',
                    'perusahaan',
                    'created_at',
                    'gambar',
                    'opsi',
                    ])->make(true);
        }
    }

    public function gambar($id)
    {
        // $data = Gs_Barangs::orderBy('id', 'asc');

        return view('superadmin.gs.view_gambar', [
           
            'item' => Gs_In_Barang::find($id),
        ]);
    }

    public function print($id, Request $request)
    {
        if ($request->tglawal) {
            $data['data'] = Gs_In_Barang::whereBetween('created_at', [$request->tglawal, $request->tglakhir])->orderBy('id', 'DESC')->get();;
        } else {
            $data['data'] = Gs_In_Barang::orderBy('id', 'DESC')->get();
        }

        $data["title"] = "Print Barang Masuk";
        $data['web'] = Gs_In_Barang::first();
        $data['tglawal'] = $request->tglawal;
        $data['tglakhir'] = $request->tglakhir;
        return view('superadmin.gs.konstruksi.consumable.gs_in_barang.print', $data);
    }

   

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        
        $perusahaan = Gs_Barangs::where('perusahaan_id', '1')->first();
        $data = $perusahaan->where('proyek_id', '1')->orderBy('kode_barang', 'asc');
        // $data = Gs_Barangs::orderBy('id', 'asc');

        if (request('cari_barang')) {
            $data->where('kode_barang', 'like', '%' . request('cari_barang') . '%')
            ->orWhere('nama_barang', 'like', '%' . request('cari_barang') . '%')
            ->orWhere('merek', 'like', '%' . request('cari_barang') . '%');
        }
        return view('superadmin.gs.konstruksi.consumable.gs_in_barang.barang', [
            'menu' => 'BMS',
            'nama_menu' => 'General Support',
            'kategori_menu' => 'Barang Masuk / Cari Barang',
            'data' => $data->paginate(),
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $data = $request->validate([
            'perusahaan_id' => 'required',
            'divisi_id' => 'required',
            'sub_divisi_id' => 'required',
            'proyek_id' => 'required',
            'gs_barang_id' => 'required',
            'jumlah' => 'required',
            'satuan' => 'required',
            'penerima' => 'required',
            'nik' => 'required',
            'suplayer' => 'required',
            'tanggal' => 'required',
            'keterangan' => 'required',
            'image' => 'required|image|file|mimes:jpg,png,jpeg,gif,svg|max:5120',
        ]);

        if($request->file('image')) {
            // $data['image'] = $request->file('image')->store('post-image');
            $data['image'] = $request->file('image')->store('image', 'public');
        }

        // dd($data);
        Gs_In_Barang::create($data);
        return redirect('sa_master_konstruksi_in_barang')->with('toast_success', 'Data Ditambahkan !');

    }

    public function add_barang($id)
    {
        // $data = Gs_Barangs::orderBy('id', 'asc');

        $data = Gs_Barangs::where('kode_barang', $id)->first();

        return view('superadmin.gs.konstruksi.consumable.gs_in_barang.add', [
            'menu' => 'BMS',
            'nama_menu' => 'General Support',
            'kategori_menu' => 'Barang Masuk',
            // 'data' => $data->paginate(1),
            'item' => $data,
        ]);
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
        
        $data = Gs_Barangs::orderBy('id', 'asc');

        if (request('cari_barang')) {
            $data->where('kode_barang', 'like', '%' . request('cari_barang') . '%')
            ->orWhere('nama_barang', 'like', '%' . request('cari_barang') . '%')
            ->orWhere('merek', 'like', '%' . request('cari_barang') . '%');
        }
        return view('superadmin.gs.konstruksi.consumable.gs_in_barang.edit', [
            'menu' => 'BMS',
            'nama_menu' => 'General Support',
            'kategori_menu' => 'Barang Masuk',
            // 'data' => $data->paginate(1),
            'item' => Gs_In_Barang::find($id),
        ]);
    }

 

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //

        $data = $request->validate([
            // 'perusahaan_id' => 'required',
            // 'divisi_id' => 'required',
            // 'sub_divisi_id' => 'required',
            // 'gs_barang_id' => 'required',
            'jumlah' => 'required',
            'satuan' => 'required',
            'penerima' => 'required',
            'nik' => 'required',
            'suplayer' => 'required',
            'tanggal' => 'required',
            'keterangan' => 'required',
            'image' => 'image|file|mimes:jpg,png,jpeg,gif,svg|max:5120',
        ]);


        if($request->file('image')) {
            if($request->imagelama) {
                Storage::delete($request->imagelama);
            }
                // Storage::delete($request->gambarlama);

            // $data['image'] = $request->file('image')->store('post-image');
            $data['image'] = $request->file('image')->store('image');
        }

        // dd($data);
        Gs_In_Barang::where('id', $id)->update($data);
        return redirect('sa_master_konstruksi_in_barang')->with('toast_success', 'Data Barang di Update ');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        Gs_In_Barang::destroy($id);
        return redirect('sa_master_konstruksi_in_barang')->with('toast_success', 'Data Barang di Hapus ');

    }
}
