<?php

namespace App\Http\Controllers;

use App\Models\Kategori;
use App\Models\Superadmin\Divisi;
use Illuminate\Http\Request;

class Kategori_Controller extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $data = Kategori::orderBy('id', 'asc');

        if (request('search')) {
            $data->where('kategori', 'like', '%' . request('search') . '%')->orWhere('nama_divisi', 'like', '%' . request('search') . '%');
        }

        return view('kategori.index', [
            'menu' => 'Master Data',
            'nama_menu' => 'Kategori',
            'data' => $data->paginate(),

            $title = 'Hapus Data',
            $text = "Apakah anda yakin ingin menghapus?",
            confirmDelete($title, $text),
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        
        return view('kategori.add', [
            'menu' => 'Master Data',
            'nama_menu' => 'Kategori',
            'divisi' => Divisi::all(),
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $data = $request->validate([
            'perusahaan_id' => 'required',
            'divisi_id' => 'required',
            'proyek_id' => 'required',
            'nama_kategori' => 'required|unique:kategoris'
        ]);

        Kategori::create($data);
        return redirect('superadmin_master_kategori')->with('toast_success', 'Kategori telah ditambahakan');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
        return view('kategori.edit', [
            'menu' => 'Master Data',
            'nama_menu' => 'Kategori',
            // 'perusahaan' => Perusahaan::all(),
            'item' => Kategori::find($id)
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
        $data = $request->validate([
            'nama_kategori' => 'required'
        ]);

        Kategori::where('id', $id)->update($data);
        return redirect('superadmin_master_kategori')->with('toast_success', 'Kategori telah di Update');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        Kategori::destroy($id);
        return redirect('superadmin_master_kategori')->with('toast_success', 'Kategori Dihapus');

    }
}
