<?php

namespace App\Http\Controllers\Admin_Area\Kendaraan;

use App\Http\Controllers\Controller;
use App\Models\Kategori;
use App\Models\Kendaraan\Kendaraan;
use App\Models\Kendaraan\Kendaraan_In;
use App\Models\Kendaraan\Kendaraan_Out;
use App\Models\Kendaraan\Pajak;
use App\Models\Kendaraan\Pajak_Riwayat;
use App\Models\Kendaraan\Servis;
use App\Models\Kendaraan\Servis_riwayat;
use App\Models\Roles;
use App\Models\Superadmin\Sub_Divisi;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class Data_Kendaraan_Controller extends Controller
{
   /**
     * Display a listing of the resource.
     */
    public function index($id)
    {
        //
        $data_data = Sub_Divisi::where('id', $id)->first();

        $data = Kendaraan::where('sub_divisi_id', $id)->orderBy('id', 'asc');

        if (request('search')) {
            $data->where('kode_motor', 'like', '%' . request('search') . '%')
            ->orWhere('nama_motor', 'like', '%' . request('search') . '%')
            ->orWhere('merek', 'like', '%' . request('search') . '%');
        }

        return view('admin_area.menu.kendaraan.kendaraan.index', [
            'data_data' =>  $data_data,
            'id' => $id,
            'data' => $data->paginate(),
     
             $title = 'Hapus Data',
             $text = "Apakah anda yakin ingin menghapus?",
             confirmDelete($title, $text),
        ]);
    }

    public function get_data(Request $request, $id) 
    {

        if ($request->ajax()) {
            if ($request->tglawal == '') {
                $data = Kendaraan::where('sub_divisi_id', $id)->orderBy('id', 'DESC')->get();
            } else {
                $data = Kendaraan::where('sub_divisi_id', $id)->whereBetween('created_at', [$request->tglawal, $request->tglakhir])->orderBy('id', 'DESC')->get();
            }
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('kendaraan', function ($row) {
                    $result = '<a href="/kendaraan/kendaraan/show/'.$row->id.'/'.$row->sub_divisi_id.'" class="fs_tabel fw-bold ">'.$row->kode_kendaraan.'</a>';

                    return $result;
                })
                ->addColumn('nama', function ($row) {
                    $result = '<div  class="fs_tabel ">'.$row->nama_kendaraan.'</div>';

                    return $result;
                })
                ->addColumn('merek', function ($row) {
                    $result = '<div  class="fs_tabel ">'.$row->merek.'</div>';

                    return $result;
                })
                ->addColumn('kategori', function ($row) {
                    $kategori = $row->kategori_id == '' ? '-' :  $row->kategori->nama_kategori;

                    $result = '<div  class="fs_tabel ">'.$kategori.'</div>';

                    return $result;
                })
                ->addColumn('sub_divisi', function ($row) {
                    $sub_divisi = $row->sub_divisi_id == '' ? '-' :  $row->sub_divisi->nama_sub_divisi;

                    $result = '<div  class="fs_tabel ">'.$sub_divisi.'</div>';

                    return $result;
                })
                ->addColumn('proyek', function ($row) {
                    $proyek = $row->proyek_id == '' ? '-' :  $row->proyek->nama_proyek;

                    $result = '<div  class="fs_tabel ">'.$proyek.'</div>';

                    return $result;
                })
                ->addColumn('divisi', function ($row) {
                    $divisi = $row->divisi_id == '' ? '-' :  $row->divisi->kode_divisi;

                    $result = '<div  class="fs_tabel ">'.$divisi.'</div>';

                    return $result;
                })
                ->addColumn('perusahaan', function ($row) {
                    $perusahaan = $row->perusahaan_id == '' ? '-' :  $row->perusahaan->kode_perusahaan;

                    $result = '<div  class="fs_tabel ">'.$perusahaan.'</div>';

                    return $result;
                })
               
                ->addColumn('opsi', function ($row) {
                    $result = '<div  class="bg-transparent d-flex flex-row text-center ">
                    <a href="/kendaraan/kendaraan/show/'.$row->id.'/'.$row->sub_divisi_id.'" class="badge-edit text-light me-1"><i class="bi bi-pencil-square"></i></a>
                    <a href="/kendaraan/delete/'.$row->id.'" class="badge-delete text-light"  data-confirm-delete="true" ><i class="bi bi-trash"></i></a>
                    </div>';

                    return $result;
                })
                ->rawColumns([
                    'tanggal', 
                    'kendaraan', 
                    'nama', 
                    'merek', 
                    'kategori', 
                    'sub_divisi', 
                    'proyek',
                    'divisi',
                    'perusahaan',
                    'opsi',
                    ])->make(true);
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create($id)
    {
        //
        $data_data = Sub_Divisi::where('id', $id)->first();
        $id = auth()->user()->id;
        $roles = Roles::where('user_id', $id)->first();
        $kategori = Kategori::where('proyek_id', $roles->proyek_id)->get();


        return view('admin_area.menu.kendaraan.kendaraan.add', [
            'data_data' =>  $data_data,
            'kategori' =>  $kategori
            
        ]);
    }

   
    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, $id)
    {
        //
        $data = $request->validate([
            'perusahaan_id' => 'required',
            'divisi_id' => 'required',
            'sub_divisi_id' => 'required',
            'proyek_id' => 'required',
            'kategori_id' => 'required',
            'kode_kendaraan' => 'required|unique:kendaraans',
            'nama_kendaraan' => 'required',
            'merek' => 'required',
        ]);

        // dd($data);

        Kendaraan::create($data);
        // Alert::success('toast_success', 'Data Barang Dtambahkan');
        return redirect('/kendaraan/kendaraan/index/'.$id)->with('toast_success', 'Data Kendaraan Ditambahkan');
     
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
        $data = Kendaraan::where('id', $id)->first();
        $id = auth()->user()->id;
        $roles = Roles::where('user_id', $id)->first();
        $kategori = Kategori::where('proyek_id', $roles->proyek_id)->get();


        return view('admin_area.menu.kendaraan.kendaraan.edit', [
            // 'data_data' =>  $data_data,
            'data' => $data,
            'kategori' =>  $kategori
            
        ]);
    }
    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id, $it)
    {
        //
        $data = $request->validate([
            // 'perusahaan_id' => 'required',
            // 'divisi_id' => 'required',
            // 'sub_divisi_id' => 'required',
            // 'proyek_id' => 'required',
            'kategori_id' => 'required',
            'kode_kendaraan' => 'required',
            'nama_kendaraan' => 'required',
            'merek' => 'required',
        ]);

        // dd($data);

        Kendaraan::where('id', $id)->update($data);
        // Alert::success('toast_success', 'Data Barang Dtambahkan');
        return redirect('/kendaraan/kendaraan/index/'.$it)->with('toast_success', 'Data Barang Di Update');

    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        Kendaraan::destroy($id);
        Kendaraan_In::where('kendaraan_id','=', $id)->delete();
        Kendaraan_Out::where('kendaraan_id','=', $id)->delete();
        Servis::where('kendaraan_id','=', $id)->delete();
        Servis_riwayat::where('kendaraan_id','=', $id)->delete();
        Pajak::where('kendaraan_id','=', $id)->delete();
        Pajak_Riwayat::where('kendaraan_id','=', $id)->delete();
        // Inventaris_Out::where('inventaris_id','=', $id)->delete();
        return back()->with('toast_success', 'Data Barang Di Hapus');
    }
}
